package cn.schoolwow.ams.domain.listener.operation;

import com.alibaba.fastjson.JSONObject;

public class AMSOperation {
    private JSONObject listener = new JSONObject();
    {
        listener.put("position", AMSOperationPosition.Row.name());
    }

    /**
     * 设置项目名
     * */
    public AMSOperation projectName(String projectName){
        listener.put("projectName", projectName);
        return this;
    }

    /**
     * 数据库名
     * */
    public AMSOperation daoName(String daoName){
        listener.put("daoName", daoName);
        return this;
    }
    
    /**
     * 表名
     * */
    public AMSOperation tableName(String tableName){
        listener.put("tableName", tableName);
        return this;
    }

    /**
     * 方法名
     * */
    public AMSOperation methodName(String methodName){
        listener.put("methodName", methodName);
        return this;
    }

    /**
     * 当前行记录字段名称列表
     * */
    public AMSOperation fieldNameList(String... fieldNameList){
        listener.put("fieldNameList", fieldNameList);
        return this;
    }

    /**
     * 查询字段名称列表
     * */
    public AMSOperation searchFieldNameList(String... searchFieldNameList){
        listener.put("searchFieldNameList", searchFieldNameList);
        return this;
    }

    /**
     * 按钮位置
     * */
    public AMSOperation position(AMSOperationPosition amsOperationPosition){
        listener.put("position", amsOperationPosition.name());
        return this;
    }

    /**
     * 处理逻辑
     * */
    public AMSOperation handle(HandleOperation handleOperation){
        listener.put("handle", handleOperation);
        return this;
    }

    /**
     * 按钮名称
     * */
    public AMSOperation name(String name){
        listener.put("name", name);
        return this;
    }

    /**
     * props属性设置
     * */
    public AMSOperation props(PropOperation propOperation){
        listener.put("props", propOperation);
        return this;
    }

    public JSONObject getListener(){
        return listener;
    }
}
