package cn.schoolwow.ams.domain.listener.routerpush;

import com.alibaba.fastjson.JSONObject;

public class AMSRouterPush {
    private JSONObject listener = new JSONObject();
    {
        listener.put("fieldNameMap", new JSONObject());
    }

    /**
     * 设置项目名
     * */
    public AMSRouterPush projectName(String projectName){
        listener.put("projectName", projectName);
        return this;
    }

    /**
     * 数据库名
     * */
    public AMSRouterPush daoName(String daoName){
        listener.put("daoName", daoName);
        return this;
    }

    /**
     * 表名
     * */
    public AMSRouterPush tableName(String tableName){
        listener.put("tableName", tableName);
        return this;
    }

    /**
     * 按钮唯一标识
     * */
    public AMSRouterPush name(String name){
        listener.put("name", name);
        return this;
    }

    /**
     * 跳转路径
     * */
    public AMSRouterPush path(String path){
        listener.put("path", path);
        return this;
    }

    /**
     * 按钮名称
     * */
    public AMSRouterPush label(String label){
        listener.put("label", label);
        return this;
    }

    /**
     * 参数列表
     * */
    public AMSRouterPush queryFieldNameList(String... queryFieldNameList){
        for(String queryFieldName:queryFieldNameList){
            queryFieldNameListMap(queryFieldName, queryFieldName);
        }
        return this;
    }

    /**
     * 参数列表映射
     * */
    public AMSRouterPush queryFieldNameListMap(String key, String value){
        JSONObject fieldNameMap = listener.getJSONObject("fieldNameMap");
        fieldNameMap.put(key, value);
        return this;
    }

    public JSONObject getListener(){
        return listener;
    }
}
