package cn.schoolwow.ams.flow.block;

import cn.schoolwow.ams.flow.block.common.GetOperationFieldFlow;
import cn.schoolwow.ams.flow.block.common.GetResourceFieldFlow;
import cn.schoolwow.quickdao.domain.external.Entity;
import cn.schoolwow.quickdao.domain.external.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class AddDatabaseEntityBlockFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        changeTimeSort(flowContext);
        setResourceFields(flowContext);
    }

    @Override
    public String name() {
        return "添加数据库表区块";
    }

    private void changeTimeSort(FlowContext flowContext){
        Entity entity = (Entity) flowContext.checkData("entity");

        //修改创建时间和更新时间的位置
        List<Property> propertyList = entity.properties;
        List<Property> propertyList1 = new ArrayList<>(propertyList);
        propertyList1.removeIf(property -> property.column.equalsIgnoreCase("created_at")||property.column.equalsIgnoreCase("updated_at"));
        {
            Property createAtProperty = entity.getPropertyByFieldNameOrColumnName("created_at");
            if(null!=createAtProperty){
                createAtProperty.comment = "创建时间";
                propertyList1.add(createAtProperty);
            }
        }
        {
            Property updateAtProperty = entity.getPropertyByFieldNameOrColumnName("updated_at");
            if(null!=updateAtProperty){
                updateAtProperty.comment = "更新时间";
                propertyList1.add(updateAtProperty);
            }
        }
        entity.properties.clear();
        entity.properties.addAll(propertyList1);
    }

    private void setResourceFields(FlowContext flowContext){
        List<String> existFieldNameList = (List<String>) flowContext.getData("existFieldNameList");
        JSONObject block = (JSONObject) flowContext.checkData("block");
        String daoName = (String) flowContext.checkData("daoName");
        Entity entity = (Entity) flowContext.checkData("entity");

        block.put("daoName", daoName);
        block.put("tableName", entity.tableName);

        List<Property> propertyList = entity.properties;
        JSONObject resourceFields = new JSONObject(true);
        JSONObject operationFields = new JSONObject(true);
        for (Property property : propertyList) {
            if (!property.column.equalsIgnoreCase("id") && property.comment.isEmpty()) {
                continue;
            }
            if (property.column.equalsIgnoreCase("id")) {
                property.comment = "id";
            }
            String label = StringUtil.underline2Camel(property.column);
            {
                JSONObject resourceField = (JSONObject) flowContext.startFlow(new GetResourceFieldFlow())
                        .putCurrentCompositeFlowData("property", property)
                        .execute()
                        .checkData("resourceField");
                resourceFields.put(label, resourceField);
            }
            if(!existFieldNameList.isEmpty()&&!existFieldNameList.contains(property.column)){
                continue;
            }
            {
                JSONObject operationField = (JSONObject) flowContext.startFlow(new GetOperationFieldFlow())
                        .putCurrentCompositeFlowData("property", property)
                        .execute()
                        .checkData("operationField");
                operationFields.put(label, operationField);
            }
        }
        block.put("resourceFields", resourceFields);
        block.put("operationFields", operationFields);
    }

}
