package cn.schoolwow.ams.flow.dispatcher;

import cn.schoolwow.ams.domain.listener.operation.HandleOperation;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class OperationDispatcherFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        String methodName = (String) flowContext.checkData("methodName");
        JSONObject requestBody = (JSONObject) flowContext.getData("requestBody");
        JSONArray amsOperationArray = (JSONArray) flowContext.getData("amsOperationArray", new JSONArray());

        if(null==amsOperationArray){
            throw new IllegalArgumentException("不支持的操作!dao:"+daoName+",表名:"+tableName+",方法名:"+methodName);
        }
        for(int i=0;i<amsOperationArray.size();i++){
            JSONObject amsOperation = amsOperationArray.getJSONObject(i);
            if(!projectName.equalsIgnoreCase(amsOperation.getString("projectName"))){
                continue;
            }
            if(!daoName.equalsIgnoreCase(amsOperation.getString("daoName"))){
                continue;
            }
            if(!tableName.equalsIgnoreCase(amsOperation.getString("tableName"))){
                continue;
            }
            if(amsOperation.containsKey("methodName")&&!methodName.equalsIgnoreCase(amsOperation.getString("methodName"))){
                continue;
            }

            if(amsOperation.containsKey("fieldNameList")){
                String[] fieldNameList = (String[])amsOperation.get("fieldNameList");
                if("MultipleSelect".equalsIgnoreCase(amsOperation.getString("position"))){
                    if(fieldNameList.length==1){
                        Validate.isTrue(requestBody.containsKey(fieldNameList[0]+"List"), fieldNameList[0]+"字段不能为空");
                        Validate.notEmpty(requestBody.getJSONArray(fieldNameList[0]+"List"), "字段不能为空");
                    }else{
                        Validate.isTrue(requestBody.containsKey("list"), "参数列表不能为空");
                        Validate.notEmpty(requestBody.getJSONArray("list"), "参数列表不能为空");
                    }
                }else{
                    for(String fieldName:fieldNameList){
                        Validate.isTrue(requestBody.containsKey(fieldName), fieldName+"参数不能为空");
                    }
                }
            }
            if(amsOperation.containsKey("searchFieldNameList")){
                Validate.isTrue(requestBody.containsKey("searchs"), "查询字段数据不能为空!");
                JSONObject searchs = requestBody.getJSONObject("searchs");
                String[] searchFieldNameList = (String[]) amsOperation.get("searchFieldNameList");
                for(String searchFieldName:searchFieldNameList){
                    Validate.isTrue(searchs.containsKey(searchFieldName), "查询字段["+searchFieldName+"]字段的值不能为空");
                }
            }
            HandleOperation handleOperation = (HandleOperation) amsOperation.get("handle");
            JSONObject response = handleOperation.handle(methodName, requestBody);
            flowContext.putData("response", response);
            return;
        }
        throw new IllegalArgumentException("不支持的操作!项目名:"+projectName+",数据库名:"+daoName+",表名:"+tableName+",方法名:"+methodName);
    }

    @Override
    public String name() {
        return "ams操作分发";
    }
}
