package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.stereotype.Service;

import java.util.Collection;

@Service
public class RefreshExtraDataFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Collection<AMSListener> amsListenerCollection = (Collection<AMSListener>) flowContext.getData("amsListenerList");
        String projectName = (String) flowContext.checkData("projectName");

        for(AMSListener amsListener:amsListenerCollection){
            if(amsListener.projectName().equalsIgnoreCase(projectName)){
                flowContext.putTemporaryData("extraData", amsListener.extraData());
                break;
            }
        }
    }

    @Override
    public String name() {
        return "刷新全局额外数据";
    }
}
