package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.ams.domain.listener.operation.PropOperation;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class SetAMSOperationFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray amsOperationArray = (JSONArray) flowContext.getData("amsOperationArray", new JSONArray());
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(int i=0;i<amsOperationArray.size();i++){
            JSONObject amsOperation = amsOperationArray.getJSONObject(i);

            for(int j=0;j<blocks.size();j++){
                JSONObject block = blocks.getJSONObject(j);

                if(!block.getString("projectName").equalsIgnoreCase(amsOperation.getString("projectName"))){
                    continue;
                }
                if(!block.getString("daoName").equalsIgnoreCase(amsOperation.getString("daoName"))){
                    continue;
                }
                if(!block.getString("tableName").equalsIgnoreCase(amsOperation.getString("tableName"))){
                    continue;
                }
                String methodName = amsOperation.getString("methodName");
                if(StringUtils.isBlank(methodName)){
                    continue;
                }
                String position = amsOperation.getString("position");
                if("None".equalsIgnoreCase(position)){
                    continue;
                }
                String name = amsOperation.getString("name");
                Validate.notEmpty(name, "名称不能为空!类名:"+amsOperation.getClass().getName());

                if(!block.containsKey("operationFields")){
                    block.put("operationFields", new JSONObject(true));
                }
                JSONObject operationFields = block.getJSONObject("operationFields");
                if("MultipleSelect".equalsIgnoreCase(position)){
                    JSONObject operationField = new JSONObject();
                    operationField.put("position", position);
                    setOperationField(operationField, amsOperation, true);
                    operationFields.put("multipleSelect_"+methodName, operationField);
                }
                JSONObject singleOperationField = new JSONObject();
                singleOperationField.put("position", position);
                setOperationField(singleOperationField, amsOperation, false);
                operationFields.put(methodName, singleOperationField);

                setBlockOperation(block, amsOperation);
            }
        }
    }

    @Override
    public String name() {
        return "设置操作按钮";
    }

    private void setOperationField(JSONObject operationField, JSONObject amsOperation, boolean checkMultiple) throws Exception {
        String name = amsOperation.getString("name");
        String methodName = amsOperation.getString("methodName");
        String position = amsOperation.getString("position");

        operationField.put("type", "button");
        operationField.put("label", name);
        {
            JSONObject props = new JSONObject();
            props.put("type", "primary");
            if(amsOperation.containsKey("props")){
                PropOperation propOperation = (PropOperation) amsOperation.get("props");
                propOperation.props(props);
            }
            operationField.put("props", props);
        }
        operationField.put("event", "confirm:确认"+name+"吗? sendRequest:"+methodName+" list:1");

        operationField.put("slot", "");
        if("RightTop".equalsIgnoreCase(position)){
            operationField.put("slot", "rightTop");
        }
        if(checkMultiple){
            if("MultipleSelect".equalsIgnoreCase(position)){
                operationField.put("slot", "multipleSelect");
                operationField.put("label", "批量"+name);
                operationField.put("event", "confirm:确认批量"+name+"吗? sendRequest:"+methodName+" list:1");
            }
        }
    }

    private void setBlockOperation(JSONObject block, JSONObject amsOperation){
        String methodName = amsOperation.getString("methodName");
        String[] fieldNameList = (String[]) amsOperation.get("fieldNameList");
        String[] searchFieldNameList = (String[]) amsOperation.get("searchFieldNameList");

        if(!block.containsKey("itemOperationMap")){
            block.put("itemOperationMap", new JSONObject());
        }
        JSONObject methodOperation = new JSONObject();
        methodOperation.put("fieldNameList", fieldNameList);
        methodOperation.put("searchFieldNameList", searchFieldNameList);

        JSONObject itemOperation = block.getJSONObject("itemOperationMap");
        itemOperation.put(methodName, methodOperation);
    }
}
