package cn.schoolwow.ams.flow.initial;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class SetAMSRouterPushFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray amsRouterPushArray = (JSONArray) flowContext.getData("amsRouterPushArray", new JSONArray());

        if(null==amsRouterPushArray||amsRouterPushArray.isEmpty()){
            return;
        }
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());

        for(int i=0;i<amsRouterPushArray.size();i++){
            JSONObject amsRouterPush = amsRouterPushArray.getJSONObject(i);
            for(int j=0;j<blocks.size();j++){
                JSONObject block = blocks.getJSONObject(j);
                if(!amsRouterPush.getString("projectName").equals(block.getString("projectName"))){
                    continue;
                }
                if(!amsRouterPush.getString("daoName").equals(block.getString("daoName"))){
                    continue;
                }
                if(!amsRouterPush.getString("tableName").equals(block.getString("tableName"))){
                    continue;
                }
                if(!block.containsKey("routerPushMap")){
                    block.put("routerPushMap", new JSONObject());
                }
                JSONObject routerPushMap = block.getJSONObject("routerPushMap");

                JSONObject routerPush = new JSONObject();
                routerPush.put("name", amsRouterPush.getString("name"));
                routerPush.put("label", amsRouterPush.getString("label"));
                routerPush.put("path", amsRouterPush.getString("path"));
                routerPush.put("queryFieldNameList", amsRouterPush.getJSONArray("queryFieldNameList"));
                routerPushMap.put(amsRouterPush.getString("name"), routerPush);

                //设置按钮
                setRouterPushButton(amsRouterPush, block);
            }
        }
    }

    @Override
    public String name() {
        return "设置跳转页面按钮";
    }

    private void setRouterPushButton(JSONObject amsRouterPush, JSONObject block){
        if(!block.containsKey("operationFields")){
            block.put("operationFields", new JSONObject(true));
        }
        JSONObject operationFields = block.getJSONObject("operationFields");
        JSONObject operationField = new JSONObject();
        {
            operationField.put("type", "button");
            operationField.put("label", amsRouterPush.getString("label"));
            {
                JSONObject props = new JSONObject();
                props.put("type", "primary");
                operationField.put("props", props);
            }
            operationField.put("event", "routerPushOperation:"+amsRouterPush.getString("name"));
        }
        operationFields.put(amsRouterPush.getString("name"), operationField);
    }

}
