/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.QuickAMS;
import cn.schoolwow.ams.flow.controller.GetConfigFlow;
import cn.schoolwow.ams.flow.controller.SetAmsInfoFlow;
import cn.schoolwow.ams.service.AMSDispatcherService;
import cn.schoolwow.ams.service.DefaultAMSDispatcherService;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ams"})
public class AMSController {
    @Resource
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private AMSDispatcherService amsDispatcherService;
    private DefaultAMSDispatcherService defaultAMSDispatcherService;
    private JSONArray blocks = new JSONArray();
    private List<String> scriptPathList = new ArrayList<String>();

    @PostConstruct
    public void postConstruct() {
        QuickAMS.quickFlow.startFlow((BusinessFlow)this.applicationContext.getBean(SetAmsInfoFlow.class)).putTemporaryData("blocks", (Object)this.blocks).putTemporaryData("scriptPathList", this.scriptPathList).execute();
        this.defaultAMSDispatcherService = new DefaultAMSDispatcherService(this.applicationContext);
    }

    @RequestMapping(value={"/config"})
    public JSONObject config() {
        FlowContext flowContext = QuickAMS.quickFlow.startFlow((BusinessFlow)this.applicationContext.getBean(GetConfigFlow.class)).putTemporaryData("blocks", (Object)this.blocks).putTemporaryData("scriptPathList", this.scriptPathList).execute();
        JSONObject config = (JSONObject)flowContext.checkData("config");
        return config;
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/list"})
    public JSONObject list(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) throws Exception {
        if (null != this.amsDispatcherService) {
            return this.amsDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
        }
        if (null != this.defaultAMSDispatcherService) {
            return this.defaultAMSDispatcherService.list(projectName, daoName, tableName, amsListConditionMap);
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/create"})
    public void create(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject createEntity) throws Exception {
        if (null != this.amsDispatcherService) {
            this.amsDispatcherService.create(projectName, daoName, tableName, createEntity);
        } else if (null != this.defaultAMSDispatcherService) {
            this.defaultAMSDispatcherService.create(projectName, daoName, tableName, createEntity);
        } else {
            throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
        }
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/edit"})
    public void edit(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestBody JSONObject updateEntity) throws Exception {
        if (null != this.amsDispatcherService) {
            this.amsDispatcherService.edit(projectName, daoName, tableName, updateEntity);
        } else if (null != this.defaultAMSDispatcherService) {
            this.defaultAMSDispatcherService.edit(projectName, daoName, tableName, updateEntity);
        } else {
            throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
        }
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/delete"})
    public void delete(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @RequestParam Map<String, Object> amsListConditionMap) throws Exception {
        if (null != this.amsDispatcherService) {
            this.amsDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
        } else if (null != this.defaultAMSDispatcherService) {
            this.defaultAMSDispatcherService.delete(projectName, daoName, tableName, amsListConditionMap);
        } else {
            throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
        }
    }

    @RequestMapping(value={"/api/{projectName}/{daoName}/{tableName}/{methodName}"})
    public JSONObject operationDispatcher(@PathVariable(value="projectName") String projectName, @PathVariable(value="daoName") String daoName, @PathVariable(value="tableName") String tableName, @PathVariable(value="methodName") String methodName, @RequestBody(required=false) JSONObject requestBody) throws Exception {
        if (null != this.amsDispatcherService) {
            return this.amsDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
        }
        if (null != this.defaultAMSDispatcherService) {
            return this.defaultAMSDispatcherService.operationDispatcher(projectName, daoName, tableName, methodName, requestBody);
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
    }

    @RequestMapping(value={"/api/{projectName}/remoteSelect/{type}"})
    public JSONArray remoteSelect(@PathVariable(value="projectName") String projectName, @PathVariable(value="type") String type, @RequestParam(required=false) Map<String, String> amsRemoteSelectMap) throws Exception {
        if (null != this.amsDispatcherService) {
            return this.amsDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
        }
        if (null != this.defaultAMSDispatcherService) {
            return this.defaultAMSDispatcherService.remoteSelect(projectName, type, amsRemoteSelectMap);
        }
        throw new UnsupportedOperationException("\u5f53\u524d\u4e0d\u5b58\u5728AmsDispatcherService\u5b9e\u4f8b");
    }
}

