/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.flow.controller;

import cn.schoolwow.ams.listener.AMSListListener;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.ams.listener.AMSRemoteSelect;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SetAmsInfoFlow
implements BusinessFlow {
    @Autowired
    private AMSListener amsListener;
    @Autowired
    private AMSListListener amsListListener;
    @Autowired(required=false)
    private List<AMSOperation> amsOperationList;
    @Autowired(required=false)
    private List<AMSRemoteSelect> amsRemoteSelectList;

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.initialBlock(flowContext);
        this.setBlockUniqueKey(flowContext);
        this.setAMSOperation(flowContext);
        this.setScriptPath(flowContext);
        this.setAMSRemoteSelect(flowContext);
    }

    public String name() {
        return "ams\u4fe1\u606f\u521d\u59cb\u5316";
    }

    private void initialBlock(FlowContext flowContext) {
        JSONArray blocks = (JSONArray)flowContext.getData("blocks", (Object)new JSONArray());
        this.amsListListener.initialBlocks(blocks);
    }

    private void setBlockUniqueKey(FlowContext flowContext) {
        JSONObject block;
        int i;
        JSONArray blocks = (JSONArray)flowContext.getData("blocks", (Object)new JSONArray());
        for (i = 0; i < blocks.size(); ++i) {
            block = blocks.getJSONObject(i);
            if (block.containsKey((Object)"projectName")) continue;
            block.put("projectName", (Object)this.amsListener.projectName());
        }
        for (i = 0; i < blocks.size(); ++i) {
            block = blocks.getJSONObject(i);
            Validate.notEmpty((CharSequence)block.getString("projectName"), (String)"block\u9879\u76ee\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)block.getString("daoName"), (String)"block\u6570\u636e\u5e93\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)block.getString("tableName"), (String)"block\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            String uniqueKey = block.getString("projectName") + "|" + block.getString("daoName") + "|" + block.getString("tableName");
            block.put("uniqueKey", (Object)uniqueKey);
            block.put("resourceName", (Object)(uniqueKey + "|resource"));
            block.put("listBlockName", (Object)(uniqueKey + "|listBlock"));
        }
    }

    private void setAMSOperation(FlowContext flowContext) {
        if (null == this.amsOperationList || this.amsOperationList.isEmpty()) {
            return;
        }
        JSONArray blocks = (JSONArray)flowContext.getData("blocks", (Object)new JSONArray());
        for (AMSOperation amsOperation : this.amsOperationList) {
            for (int i = 0; i < blocks.size(); ++i) {
                String methodName;
                JSONObject block = blocks.getJSONObject(i);
                if (!this.amsListener.projectName().equals(block.getString("projectName")) || !amsOperation.daoName().equals(block.getString("daoName")) || !amsOperation.tableName().equals(block.getString("tableName")) || StringUtils.isBlank((CharSequence)(methodName = amsOperation.methodName())) || methodName.endsWith("Ignore")) continue;
                if (!block.containsKey((Object)"operations")) {
                    block.put("operations", (Object)new JSONArray());
                }
                JSONArray operations = block.getJSONArray("operations");
                JSONObject operation = new JSONObject();
                operation.put("key", (Object)amsOperation.methodName());
                operation.put("label", (Object)amsOperation.name());
                Validate.notEmpty((CharSequence)operation.getString("label"), (String)("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!\u7c7b\u540d:" + amsOperation.getClass().getName()), (Object[])new Object[0]);
                operation.put("fieldNameList", (Object)amsOperation.fieldNameList());
                JSONObject props = new JSONObject();
                props.put("type", (Object)"primary");
                amsOperation.props(props);
                operation.put("props", (Object)props);
                if (amsOperation.methodName().startsWith("multiple")) {
                    operation.put("slot", (Object)"multipleSelect");
                }
                if (amsOperation.methodName().endsWith("RightTop")) {
                    operation.put("slot", (Object)"rightTop");
                }
                operations.add((Object)operation);
            }
        }
    }

    private void setAMSRemoteSelect(FlowContext flowContext) {
        if (null == this.amsRemoteSelectList || this.amsRemoteSelectList.isEmpty()) {
            return;
        }
        JSONArray blocks = (JSONArray)flowContext.getData("blocks", (Object)new JSONArray());
        for (AMSRemoteSelect amsRemoteSelect : this.amsRemoteSelectList) {
            String[] uniqueKeyFieldArray = amsRemoteSelect.uniqueKeyFieldArray();
            if (null == uniqueKeyFieldArray || uniqueKeyFieldArray.length == 0) continue;
            for (int i = 0; i < blocks.size(); ++i) {
                JSONObject block = blocks.getJSONObject(i);
                String uniqueKey = block.getString("uniqueKey");
                for (String uniqueKeyField : uniqueKeyFieldArray) {
                    JSONObject operationFields;
                    String parameter;
                    if (!uniqueKeyField.startsWith(uniqueKey)) continue;
                    String[] tokens = uniqueKeyField.split("\\|", -1);
                    String projectName = tokens[0];
                    String fieldName = tokens[3];
                    String comment = tokens[4];
                    String string = parameter = tokens.length >= 6 ? tokens[5] : null;
                    if (!block.containsKey((Object)"operationFields")) {
                        block.put("operationFields", (Object)new JSONObject());
                    }
                    if (!(operationFields = block.getJSONObject("operationFields")).containsKey((Object)fieldName)) {
                        operationFields.put(fieldName, (Object)new JSONObject());
                    }
                    JSONObject operationField = operationFields.getJSONObject(fieldName);
                    this.setRemoteSelectOperation(projectName, comment, parameter, amsRemoteSelect.type(), operationField);
                    JSONObject resourceField = new JSONObject();
                    resourceField.put("label", (Object)comment);
                    resourceField.put("info", (Object)comment);
                    resourceField.put("type", (Object)"text");
                    block.getJSONObject("resourceFields").put(fieldName, (Object)resourceField);
                }
            }
        }
    }

    private void setScriptPath(FlowContext flowContext) throws IOException {
        List scriptPathList = (List)flowContext.getData("scriptPathList", new ArrayList());
        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/ams"));
        scriptPathList.addAll(AMSUtil.getJavascriptResourcePathList("static/commonOperation"));
        this.amsListListener.initialScriptPath(scriptPathList);
    }

    private void setRemoteSelectOperation(String projectName, String comment, String parameter, String type, JSONObject operationField) {
        operationField.put("slot", (Object)"searchs");
        operationField.put("type", (Object)"field");
        operationField.put("label", (Object)comment);
        JSONObject field = new JSONObject();
        field.put("BASE", (Object)"SELECT_REMOTE");
        field.put("type", (Object)"select");
        field.put("info", (Object)comment);
        JSONObject props = new JSONObject();
        props.put("placeholder", (Object)("\u8bf7\u9009\u62e9" + comment));
        props.put("clearable", (Object)true);
        props.put("multiple", (Object)false);
        field.put("props", (Object)props);
        JSONObject remoteConfig = new JSONObject();
        remoteConfig.put("dataPath", (Object)"data");
        remoteConfig.put("action", (Object)("/ams/api/" + projectName + "/remoteSelect/" + type + (StringUtils.isNotBlank((CharSequence)parameter) ? "?" + parameter : "")));
        remoteConfig.put("queryKey", (Object)"name");
        remoteConfig.put("isCache", (Object)false);
        field.put("remoteConfig", (Object)remoteConfig);
        operationField.put("field", (Object)field);
    }
}

