/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.flow.dispatcher;

import cn.schoolwow.ams.listener.AMSOperation;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

@Service
public class OperationDispatcherFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = (String)flowContext.checkData("projectName");
        String daoName = (String)flowContext.checkData("daoName");
        String tableName = (String)flowContext.checkData("tableName");
        String methodName = (String)flowContext.checkData("methodName");
        JSONObject requestBody = (JSONObject)flowContext.getData("requestBody");
        Collection amsOperationList = (Collection)flowContext.getData("amsOperationList");
        if (null == amsOperationList) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c!dao:" + daoName + ",\u8868\u540d:" + tableName + ",\u65b9\u6cd5\u540d:" + methodName);
        }
        for (AMSOperation amsOperation : amsOperationList) {
            if (!daoName.equalsIgnoreCase(amsOperation.daoName()) || !tableName.equalsIgnoreCase(amsOperation.tableName()) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{amsOperation.methodName()}) && !methodName.equalsIgnoreCase(amsOperation.methodName())) continue;
            String[] fieldNameList = amsOperation.fieldNameList();
            if (null != fieldNameList) {
                if (amsOperation.methodName().startsWith("multiple")) {
                    if (fieldNameList.length == 1) {
                        Validate.isTrue((boolean)requestBody.containsKey((Object)(fieldNameList[0] + "List")), (String)(fieldNameList[0] + "\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                        Validate.notEmpty((Collection)requestBody.getJSONArray(fieldNameList[0] + "List"), (String)"\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    } else {
                        Validate.isTrue((boolean)requestBody.containsKey((Object)"list"), (String)"\u53c2\u6570\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notEmpty((Collection)requestBody.getJSONArray("list"), (String)"\u53c2\u6570\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                    }
                } else {
                    for (String fieldName : fieldNameList) {
                        Validate.isTrue((boolean)requestBody.containsKey((Object)fieldName), (String)(fieldName + "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"), (Object[])new Object[0]);
                    }
                }
            }
            JSONObject response = amsOperation.handle(methodName, requestBody);
            flowContext.putData("response", (Object)response);
            return;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c!\u9879\u76ee\u540d:" + projectName + ",\u6570\u636e\u5e93\u540d:" + daoName + ",\u8868\u540d:" + tableName + ",\u65b9\u6cd5\u540d:" + methodName);
    }

    public String name() {
        return "ams\u64cd\u4f5c\u5206\u53d1";
    }
}

