ams.config({
    "resource": {
        requestInterceptor(options) {
            if (options.url.indexOf("?") > 0) {
                options.url += "&t=" + new Date().getTime();
            } else {
                options.url += "?t=" + new Date().getTime();
            }
            return options;
        },
        "api": {
            "contentType": "json"
        }
    },
    "defaultFieldConfig": {
        "text": {
            "style": {
                "cursor": "pointer"
            },
            "view": function (val, field, row) {
                if (null == val) {
                    return;
                }
                if (typeof (val) == "object" || typeof (val) == "array") {
                    val = JSON.stringify(val);
                }
                if (val.length > 50) {
                    //显示前20个和后30个字符
                    return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
                }
                return val;
            },
        },
        "textarea": {
            "style": {
                "cursor": "pointer"
            },
            "view": function (val, field, row) {
                if (null == val) {
                    return;
                }
                if (typeof (val) == "object" || typeof (val) == "array") {
                    val = JSON.stringify(val);
                }
                if (val.length > 50) {
                    //显示前20个和后30个字符
                    return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
                }
                return val;
            },
        },
        "link":{
            "style": {
                "color": "blue"
            },
            "props": {
                "href": function(e) {
                    return e;
                },
                "target": "_blank"
            },
            "view": function (val, field, row) {
                if (null == val) {
                    return;
                }
                if (typeof (val) == "object" || typeof (val) == "array") {
                    val = JSON.stringify(val);
                }
                if (val.length > 50) {
                    //显示前20个和后30个字符
                    return val.substring(0,20) + "......" + val.substring(val.length-30,val.length);
                }
                return val;
            },
        }
    },
});