package cn.schoolwow.ams.listener;

import cn.schoolwow.ams.domain.BeforeEditOption;
import cn.schoolwow.quickdao.dao.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.external.PageVo;
import com.alibaba.fastjson.JSONObject;

public interface AMSTableListener {
    /**
     * 数据库名
     * */
    String daoName();

    /**
     * 表名
     * */
    String tableName();

    /**
     * 执行数据库请求前
     * */
    void beforeExecuteCondition(Condition condition, JSONObject amsListCondition) throws Exception;

    /**
     * 执行数据库请求后
     * */
    void afterExecuteCondition(Condition condition, JSONObject amsListCondition, PageVo pageVo) throws Exception;

    /**
     * 增加实体类之前
     * */
    void beforeCreate(JSONObject createEntity) throws Exception;

    /**
     * 增加实体类之后
     * */
    void afterCreate(JSONObject createEntity) throws Exception;

    /**
     * 更新实体类之前
     * */
    BeforeEditOption beforeEdit(JSONObject updateEntity) throws Exception;

    /**
     * 更新实体类之后
     * */
    void afterEdit(BeforeEditOption beforeEditOption, JSONObject updateEntity) throws Exception;

    /**
     * 删除实体类之前
     * */
    void beforeDelete(Condition condition, JSONObject amsListCondition) throws Exception;

    /**
     * 删除实体类之后
     * */
    void afterDelete(Condition condition, JSONObject amsListCondition) throws Exception;
}
