/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.flow.controller;

import cn.schoolwow.ams.flow.composite.SetAMSInfoCompositeBusiness;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class GetConfigFlow
implements BusinessFlow {
    @Value(value="${spring.profiles.active}")
    private String activeProfile;
    @Resource
    private ApplicationContext applicationContext;
    @Autowired
    private AMSListener amsListener;

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONArray blocks = (JSONArray)flowContext.getData("blocks", (Object)new JSONArray());
        List scriptPathList = (List)flowContext.getData("scriptPathList", new ArrayList());
        if (!"docker".equals(this.activeProfile)) {
            blocks.clear();
            scriptPathList.clear();
            flowContext.executeCompositeFlowList(new CompositeBusinessFlow[]{(CompositeBusinessFlow)this.applicationContext.getBean(SetAMSInfoCompositeBusiness.class)});
        }
        JSONObject config = new JSONObject();
        config.put("projectName", (Object)this.amsListener.projectName());
        config.put("applicationName", (Object)this.amsListener.applicationName());
        JSONObject blockMap = new JSONObject();
        for (int i = 0; i < blocks.size(); ++i) {
            JSONObject block = blocks.getJSONObject(i);
            blockMap.put(block.getString("uniqueKey"), (Object)block);
        }
        config.put("blockMap", (Object)blockMap);
        config.put("scriptPathList", (Object)scriptPathList);
        config.put("extraData", (Object)this.amsListener.extraData());
        flowContext.putData("config", (Object)config);
    }

    public String name() {
        return "\u83b7\u53d6ams\u9875\u9762\u914d\u7f6e\u4fe1\u606f";
    }
}

