/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.controller;

import cn.schoolwow.ams.domain.AMSResult;
import cn.schoolwow.ams.listener.AMSGlobalConfig;
import cn.schoolwow.ams.listener.AMSListener;
import cn.schoolwow.quickflow.exception.QuickFlowRuntimeException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class AMSExceptionHandler {
    @Autowired(required=false)
    private AMSGlobalConfig amsGlobalConfig;
    @Autowired
    private List<AMSListener> amsListenerList;

    @ExceptionHandler(value={QuickFlowRuntimeException.class})
    @ResponseBody
    public AMSResult handleException(QuickFlowRuntimeException ex) {
        return this.getAMSResult(ex.targetException);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public AMSResult handleException(Exception ex) {
        return this.getAMSResult(ex);
    }

    private AMSResult getAMSResult(Exception ex) {
        if (null != this.amsGlobalConfig) {
            this.amsGlobalConfig.beforePrintError(ex);
        } else if (this.amsListenerList.size() == 1) {
            this.amsListenerList.get(0).beforePrintError(ex);
        } else {
            throw new IllegalArgumentException("\u672a\u914d\u7f6eAMSGlobalConfig\u5bf9\u8c61\u6216\u8005ams\u9879\u76ee\u5927\u4e8e1\u4e2a!ams\u9879\u76ee\u4e2a\u6570:" + this.amsListenerList.size());
        }
        return new AMSResult(ex.getMessage());
    }
}

