/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;

public class ReflectionUtil {
    public static Object getInstanceFieldValue(Object instance, String fieldName) {
        try {
            Field field = ReflectionUtil.searchFieldFromSuperClass(fieldName, instance.getClass());
            Object value = field.get(instance);
            return value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Field[] getFieldsFromSuperClass(Class clazz) {
        ArrayList<AccessibleObject> fieldList = new ArrayList<AccessibleObject>();
        while (null != clazz) {
            AccessibleObject[] fields = clazz.getDeclaredFields();
            Field.setAccessible(fields, true);
            fieldList.addAll(Arrays.asList(fields));
            clazz = clazz.getSuperclass();
        }
        return fieldList.toArray(new Field[0]);
    }

    public static Field searchFieldFromSuperClass(String fieldName, Class clazz) {
        String initialClassName = clazz.getName();
        while (null != clazz.getSuperclass()) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new IllegalArgumentException("\u5b57\u6bb5\u4e0d\u5b58\u5728!\u5b57\u6bb5\u540d:" + fieldName + ",\u7c7b\u540d:" + initialClassName);
    }
}

