package cn.schoolwow.ams.domain.listener.operation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**AMS操作分发*/
public interface AMSDispatcherService {
    /**
     * list方法
     * @param projectName 项目名
     * @param daoName 数据库名
     * @param tableName 表名
     * @param amsListConditionMap 请求参数
     * */
    JSONObject list(String projectName, String daoName, String tableName, Map<String,Object> amsListConditionMap) throws Exception;

    /**
     * create方法
     * @param projectName 项目名
     * @param daoName 数据库名
     * @param tableName 表名
     * @param createEntity 待创建的实体类信息
     * */
    void create(String projectName, String daoName, String tableName, JSONObject createEntity) throws Exception;

    /**
     * edit方法
     * @param projectName 项目名
     * @param daoName 数据库名
     * @param tableName 表名
     * @param updateEntity 待更新的实体类信息
     * */
    void edit(String projectName, String daoName, String tableName, JSONObject updateEntity) throws Exception;

    /**
     * delete方法
     * @param projectName 项目名
     * @param daoName 数据库名
     * @param tableName 表名
     * @param amsListConditionMap 请求参数
     * */
    void delete(String projectName, String daoName, String tableName, Map<String,Object> amsListConditionMap) throws Exception;

    /**
     * operation请求分发
     * @param projectName 项目名
     * @param daoName 数据库名
     * @param tableName 表名
     * @param methodName 方法名
     * @param requestBody 请求参数
     * */
    JSONObject operationDispatcher(String projectName, String daoName, String tableName, String methodName, JSONObject requestBody) throws Exception;

    /**
     * 远程下拉框选项
     * @param projectName 项目名
     * @param type 类型
     * @param amsListConditionMap 条件
     * */
    JSONArray remoteSelect(String projectName, String type, Map<String,String> amsListConditionMap) throws Exception;
}
