package cn.schoolwow.ams.module.config.advice;

import cn.schoolwow.ams.domain.AMSGlobalConfig;
import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.domain.AMSResult;
import cn.schoolwow.quickflow.exception.QuickFlowRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

@ControllerAdvice
public class AMSExceptionHandler {

    @Autowired(required = false)
    private AMSGlobalConfig amsGlobalConfig;

    @Autowired
    private List<AMSListener> amsListenerList;

    @ExceptionHandler(QuickFlowRuntimeException.class)
    @ResponseBody
    public AMSResult handleException(QuickFlowRuntimeException ex) {
        return getAMSResult(ex.targetException);
    }

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public AMSResult handleException(Exception ex) {
        return getAMSResult(ex);
    }

    private AMSResult getAMSResult(Exception ex){
        if(null!=amsGlobalConfig){
            amsGlobalConfig.beforePrintError(ex);
        }else if(amsListenerList.size()==1){
            amsListenerList.get(0).beforePrintError(ex);
        }else{
            throw new IllegalArgumentException("未配置AMSGlobalConfig对象或者ams项目大于1个!ams项目个数:"+amsListenerList.size());
        }
        return new AMSResult(ex.getMessage());
    }
}
