package cn.schoolwow.ams.module.initial.flow;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class ClearAMSInfoFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Map<String,Object> contextMap = flowContext.getContextDataMap();
        {
            JSONArray array = (JSONArray) contextMap.get("blocks");
            array.clear();
        }
        {
            List<String> scriptPathList = (List<String>) contextMap.get("scriptPathList");
            scriptPathList.clear();
        }
        {
            List<String> remoteSelectContextList = (List<String>) contextMap.get("remoteSelectContextList");
            remoteSelectContextList.clear();
        }
    }

    @Override
    public String name() {
        return "清空初始化信息";
    }
}
