package cn.schoolwow.ams.module.initial.flow;

import cn.schoolwow.ams.domain.AMSGlobalConfig;
import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.module.initial.service.SetAMSInfoCompositeBusiness;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class GetConfigFlow implements BusinessFlow {
    @Autowired(required = false)
    private AMSGlobalConfig amsGlobalConfig;

    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        refresh(flowContext);
        getFromCache(flowContext);
        getConfig(flowContext);
    }

    @Override
    public String name() {
        return "获取ams页面配置信息";
    }

    private void refresh(FlowContext flowContext){
        if(null!=amsGlobalConfig&&amsGlobalConfig.shouldRefresh()){
            flowContext.startFlow(applicationContext.getBean(ClearAMSInfoFlow.class))
                    .next(applicationContext.getBean(SetAMSInfoCompositeBusiness.class));
        }
    }

    private void getFromCache(FlowContext flowContext){
        String projectName = (String) flowContext.checkData("projectName");
        Map<String,JSONObject> projectNameConfigMap = (Map<String, JSONObject>) flowContext.getData("projectNameConfigMap", new HashMap<>());

        if(projectNameConfigMap.containsKey(projectName)){
            JSONObject config = projectNameConfigMap.get(projectName);
            flowContext.putTemporaryData("config", config);
            flowContext.brokenCurrentFlow("从缓存中获取");
        }
    }

    private void getConfig(FlowContext flowContext){
        String projectName = (String) flowContext.checkData("projectName");
        Map<String,JSONObject> projectNameConfigMap = (Map<String, JSONObject>) flowContext.getData("projectNameConfigMap", new HashMap<>());
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());
        List<String> scriptPathList = (List<String>) flowContext.getData("scriptPathList", new ArrayList<>());
        Collection<AMSListener> amsListenerList = (Collection<AMSListener>) flowContext.checkData("amsListenerList");

        for(AMSListener amsListener:amsListenerList){
            if(amsListener.projectName().equalsIgnoreCase(projectName)){
                JSONObject config = new JSONObject();
                config.put("projectName", amsListener.projectName());
                config.put("applicationName", amsListener.applicationName());
                //修改blocks显示方式,方便前端排查
                JSONObject blockMap = new JSONObject();
                for(int i=0;i<blocks.size();i++){
                    JSONObject block = blocks.getJSONObject(i);
                    if(projectName.equalsIgnoreCase(block.getString("projectName"))){
                        blockMap.put(block.getString("uniqueKey"), block);
                    }
                }
                config.put("blockMap", blockMap);
                List<String> currentProjectScriptPathList = new ArrayList<>();
                for(String scriptPath:scriptPathList){
                    if(scriptPath.startsWith("/ams/"+projectName)||scriptPath.startsWith("/ams/commonOperation")){
                        currentProjectScriptPathList.add(scriptPath);
                    }
                }
                config.put("scriptPathList", currentProjectScriptPathList);
                config.put("extraData", amsListener.extraData());
                projectNameConfigMap.put(projectName, config);
                flowContext.putTemporaryData("config", config);
                return;
            }
        }
        throw new IllegalArgumentException("根据项目名未找到匹配的项目配置!项目名:"+projectName);
    }
}
