package cn.schoolwow.ams.module.initial.flow.get;

import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.ams.domain.list.AMSTableConfigAware;
import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Service
public class GetAMSTableConfigListFlow implements BusinessFlow {
    @Autowired(required = false)
    private List<AMSTableConfigAware> amsTableListenerAwareList;

    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        if(null==amsTableListenerAwareList||amsTableListenerAwareList.isEmpty()){
            return;
        }
        Collection<AMSListener> amsListenerList = (Collection<AMSListener>) flowContext.checkData("amsListenerList");

        List<AMSTableConfig> amsTableConfigList = new ArrayList<>();
        for(AMSTableConfigAware amsTableConfigAware:amsTableListenerAwareList){
            AMSTableConfig amsTableConfig = amsTableConfigAware.getAMSTableConfig();
            Validate.notNull(amsTableConfig, "表配置不能为空!涉及类名:"+amsTableConfigAware.getClass().getName());

            Validate.notEmpty(amsTableConfig.projectName, "项目名不能为空!字段名:projectName,涉及类名:"+amsTableConfigAware.getClass().getName());
            Validate.notEmpty(amsTableConfig.daoName, "DAO名不能为空!字段名:daoName,涉及类名:"+amsTableConfigAware.getClass().getName());
            Validate.notEmpty(amsTableConfig.label, "表显示名称不能为空!字段名:label,涉及类名:"+amsTableConfigAware.getClass().getName());
            if(StringUtils.isBlank(amsTableConfig.tableName)&&null==amsTableConfig.entity){
                throw new IllegalArgumentException("表名和Entity类必须设置其中一个!涉及类名:"+amsTableConfigAware.getClass().getName());
            }

            DAO dao = null;
            for(AMSListener amsListener:amsListenerList){
                if(amsListener.projectName().equals(amsTableConfig.projectName)){
                    dao = amsListener.getDAO(amsTableConfig.daoName);
                    break;
                }
            }
            Validate.notNull(dao, "数据库不存在!dao名称:"+amsTableConfig.daoName+",涉及类:"+amsTableConfigAware.getClass().getName());
            if(null!=amsTableConfig.tableName){
                amsTableConfig.entity = dao.getDatabaseEntity(amsTableConfig.tableName);
            }else if(null!=amsTableConfig.entity){
                amsTableConfig.tableName = amsTableConfig.entity.tableName;
            }
            amsTableConfigList.add(amsTableConfig);
        }
        flowContext.putContextData("amsTableConfigList", amsTableConfigList);
    }

    @Override
    public String name() {
        return "设置数据库表配置列表信息";
    }
}
