package cn.schoolwow.ams.module.initial.flow.get;

import cn.schoolwow.ams.domain.AMSClazzConfig;
import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class GetBlockArrayFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setFromTableConfigList(flowContext);
        setFromClazzConfigList(flowContext);
        setCommonFields(flowContext);
    }

    @Override
    public String name() {
        return "设置block列表";
    }

    private void setFromTableConfigList(FlowContext flowContext){
        List<AMSTableConfig> amsTableConfigList = (List<AMSTableConfig>) flowContext.getData("amsTableConfigList");
        if(null==amsTableConfigList||amsTableConfigList.isEmpty()){
            return;
        }
        JSONArray blocks = (JSONArray) flowContext.getData("blocks");
        for(AMSTableConfig amsTableConfig:amsTableConfigList){
            JSONObject block = new JSONObject();
            block.put("projectName", amsTableConfig.projectName);
            block.put("daoName", amsTableConfig.daoName);
            if(null!=amsTableConfig.entity.clazz){
                block.put("tableName", amsTableConfig.entity.clazz.getSimpleName());
            }else{
                block.put("tableName", amsTableConfig.tableName);
            }
            blocks.add(block);
        }
    }

    private void setFromClazzConfigList(FlowContext flowContext){
        List<AMSClazzConfig> amsClazzConfigList = (List<AMSClazzConfig>) flowContext.getData("amsClazzConfigList");
        if(null==amsClazzConfigList||amsClazzConfigList.isEmpty()){
            return;
        }
        JSONArray blocks = (JSONArray) flowContext.getData("blocks");
        for(AMSClazzConfig amsClazzConfig:amsClazzConfigList){
            JSONObject block = new JSONObject();
            block.put("projectName", amsClazzConfig.projectName);
            block.put("daoName", "clazz");
            block.put("tableName", amsClazzConfig.clazzName);
            blocks.add(block);
        }
    }

    private void setCommonFields(FlowContext flowContext){
        JSONArray blocks = (JSONArray) flowContext.getData("blocks");
        for(int i=0;i<blocks.size();i++){
            JSONObject block = blocks.getJSONObject(i);
            Validate.notEmpty(block.getString("projectName"), "项目名不能为空");
            Validate.notEmpty(block.getString("daoName"), "数据库名不能为空");
            Validate.notEmpty(block.getString("tableName"), "实体类/自定义类名不能为空");
            String uniqueKey = block.getString("projectName")+"|"+block.getString("daoName")+"|"+block.getString("tableName");
            block.put("uniqueKey", uniqueKey);
            block.put("resourceName", uniqueKey+"|resource");
            block.put("listBlockName", uniqueKey+"|listBlock");
        }
    }
}
