package cn.schoolwow.ams.module.initial.flow.get;

import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.ams.module.initial.flow.set.common.GetMatchBlockFlow;
import cn.schoolwow.ams.module.initial.flow.set.field.table.SetAMSTableFieldFlow;
import cn.schoolwow.ams.module.initial.flow.set.field.table.SetAMSTableListTableFieldFlow;
import cn.schoolwow.ams.module.initial.flow.set.operation.SetCopyFieldButtonFlow;
import cn.schoolwow.ams.module.initial.flow.set.resource.*;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetAMSTableConfigFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<AMSTableConfig> amsTableConfigList = (List<AMSTableConfig>) flowContext.getData("amsTableConfigList");
        if(null==amsTableConfigList||amsTableConfigList.isEmpty()){
            return;
        }

        for(AMSTableConfig amsTableConfig:amsTableConfigList){
            flowContext.startFlow("设置单个数据库表资源信息")
                    .putCurrentCompositeFlowData("amsTableConfig", amsTableConfig)
                    .putCurrentCompositeFlowData("className", amsTableConfig.getClass().getName())
                    .putCurrentCompositeFlowData("label", amsTableConfig.label)
                    .putCurrentCompositeFlowData("amsRemoteSelectList", amsTableConfig.amsRemoteSelectList)
                    .putCurrentCompositeFlowData("listBlockOption", amsTableConfig.listBlockOption)
                    .putCurrentCompositeFlowData("amsDialog", amsTableConfig.amsDialog)
                    .putCurrentCompositeFlowData("amsRouterPushList", amsTableConfig.amsRouterPushList)
                    .putCurrentCompositeFlowData("copyFieldCommentMap", amsTableConfig.copyFieldCommentMap)
                    .putCurrentCompositeFlowData("amsOperationButtonList", amsTableConfig.amsOperationButtonList)
                    .putCurrentCompositeFlowData("amsTableListener", amsTableConfig.amsTableListener)
                    .putCurrentCompositeFlowData("projectName", amsTableConfig.projectName)
                    .next(new GetMatchBlockFlow())
                    .next(new SetAMSTableFieldFlow())
                    .next(new SetAMSTableListTableFieldFlow())
                    .next(new SetListBlockOptionFlow())
                    .next(new SetTableDialogFlow())
                    .next(new SetTableRouterPushFlow())
                    .next(new SetCopyFieldButtonFlow())
                    .next(new SetAMSOperationButtonFlow())
                    .next(new SetTableRemoteSelectFlow())
                    .execute();
        }
    }

    @Override
    public String name() {
        return "设置数据库表资源信息";
    }

}
