package cn.schoolwow.ams.module.initial.flow.set.common;

import cn.schoolwow.ams.domain.AMSClazzConfig;
import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class GetMatchBlockFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setUniqueKey(flowContext);
        setMatchBlock(flowContext);
    }

    @Override
    public String name() {
        return "获取匹配的block";
    }

    private void setUniqueKey(FlowContext flowContext){
        AMSTableConfig amsTableConfig = (AMSTableConfig) flowContext.getData("amsTableConfig");
        AMSClazzConfig amsClazzConfig = (AMSClazzConfig) flowContext.getData("amsClazzConfig");

        if(null!=amsTableConfig){
            String tableName = amsTableConfig.tableName;
            if(null!=amsTableConfig.entity.clazz){
                tableName = amsTableConfig.entity.clazz.getSimpleName();
            }
            String uniqueKey = amsTableConfig.projectName+"|"+amsTableConfig.daoName+"|"+tableName;
            flowContext.putCurrentFlowData("uniqueKey", uniqueKey);
        }
        if(null!=amsClazzConfig){
            String uniqueKey = amsClazzConfig.projectName+"|clazz|"+amsClazzConfig.clazzName;
            flowContext.putCurrentFlowData("uniqueKey", uniqueKey);
        }
    }

    private void setMatchBlock(FlowContext flowContext){
        JSONArray blocks = (JSONArray) flowContext.getData("blocks", new JSONArray());
        String uniqueKey = (String) flowContext.checkData("uniqueKey");

        for(int i=0;i<blocks.size();i++){
            JSONObject block = blocks.getJSONObject(i);
            if(uniqueKey.equals(block.getString("uniqueKey"))){
                flowContext.putCurrentCompositeFlowData("matchBlock", block);

                if(!block.containsKey("operationFields")){
                    block.put("operationFields", new JSONObject(true));
                }
                if(!block.containsKey("blockConfig")){
                    block.put("blockConfig", new JSONObject(true));
                }
                if(!block.containsKey("operationFields")){
                    block.put("operationFields", new JSONObject(true));
                }
                if(!block.containsKey("resourceFields")){
                    block.put("resourceFields", new JSONObject(true));
                }
                return;
            }
        }
        throw new IllegalArgumentException("表不存在!表唯一值:"+uniqueKey);
    }
}
