package cn.schoolwow.ams.module.initial.flow.set.field.clazz;

import cn.schoolwow.ams.domain.annotation.AMSColumnType;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

import java.lang.reflect.Field;

public class GetClazzBasicResourceFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String comment = (String) flowContext.checkData("comment");
        Field entityField = (Field) flowContext.checkData("entityField");

        JSONObject field = new JSONObject();
        field.put("label", comment);
        field.put("info", "请输入" + comment);
        AMSColumnType amsColumnType = entityField.getAnnotation(AMSColumnType.class);
        if(null!=amsColumnType){
            field.put("type", amsColumnType.value());
        }else{
            switch (entityField.getType().getName()) {
                case "java.util.Date":
                case "java.sql.LocalDate":{
                    field.put("type", "date");
                }break;
                case "java.sql.Timestamp":
                case "java.sql.LocalDateTime": {
                    field.put("type", "datetime");
                }break;
                case "com.alibaba.fastjson.JSONObject":
                case "com.alibaba.fastjson.JSONArray":{
                    field.put("type", "textarea");
                }break;
                default: {
                    field.put("type", "text");
                }
            }
        }

        JSONObject props = new JSONObject();
        props.put("placeholder", "请输入" + comment);
        field.put("props", props);

        flowContext.putReturnData("resourceField", field);
    }

    @Override
    public String name() {
        return "获取自定义类一般字段信息";
    }
}
