package cn.schoolwow.ams.module.initial.flow.set.field.clazz;

import cn.schoolwow.ams.domain.AMSClazzConfig;
import cn.schoolwow.ams.domain.listener.list.ListBlockOption;
import cn.schoolwow.ams.module.initial.flow.set.field.common.GetOperationFieldFlow;
import cn.schoolwow.ams.module.initial.flow.set.field.common.GetSelectResourceFieldFlow;
import cn.schoolwow.ams.util.ReflectionUtil;
import cn.schoolwow.quickdao.annotation.Comment;
import cn.schoolwow.quickdao.annotation.Ignore;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class SetAMSClazzFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setRequestFields(flowContext);
        setResponseFields(flowContext);
    }

    @Override
    public String name() {
        return "设置自定义类请求和响应字段";
    }

    private void setRequestFields(FlowContext flowContext) throws NoSuchFieldException {
        AMSClazzConfig amsClazzConfig = (AMSClazzConfig) flowContext.checkData("amsClazzConfig");
        ListBlockOption listBlockOption = (ListBlockOption) flowContext.getData("listBlockOption");

        if(null==listBlockOption.requestFieldNames){
            Field[] entityFields = ReflectionUtil.getFieldsFromSuperClass(amsClazzConfig.requestClass);
            Field.setAccessible(entityFields, true);
            for (Field entityField : entityFields) {
                setResourceField(entityField, flowContext);
            }
        }else{
            for(String requestFieldName:listBlockOption.requestFieldNames){
                Field entityField = ReflectionUtil.searchFieldFromSuperClass(requestFieldName, amsClazzConfig.requestClass);
                entityField.setAccessible(true);
                setResourceField(entityField, flowContext);
            }
        }
    }

    private void setResponseFields(FlowContext flowContext) throws NoSuchFieldException {
        AMSClazzConfig amsClazzConfig = (AMSClazzConfig) flowContext.checkData("amsClazzConfig");
        ListBlockOption listBlockOption = (ListBlockOption) flowContext.getData("listBlockOption");

        if(null==listBlockOption.responseFieldNames){
            Field[] entityFields = ReflectionUtil.getFieldsFromSuperClass(amsClazzConfig.responseClass);
            Field.setAccessible(entityFields, true);
            for (Field entityField : entityFields) {
                setOperationField(entityField, flowContext);
            }
        }else{
            for(String responseFieldName:listBlockOption.responseFieldNames){
                Field entityField = ReflectionUtil.searchFieldFromSuperClass(responseFieldName, amsClazzConfig.responseClass);
                entityField.setAccessible(true);
                setOperationField(entityField, flowContext);
            }
        }
    }

    private void setResourceField(Field entityField, FlowContext flowContext){
        AMSClazzConfig amsClazzConfig = (AMSClazzConfig) flowContext.checkData("amsClazzConfig");
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        if(Modifier.isTransient(entityField.getModifiers())){
            return;
        }
        if(null!=entityField.getAnnotation(Ignore.class)){
            return;
        }
        String comment = null;
        Comment commentAnnotation = entityField.getAnnotation(Comment.class);
        if(null==commentAnnotation){
            switch (entityField.getName()){
                case "id":{comment ="自增id";}break;
                case "createdAt":{comment ="创建时间";}break;
                case "updatedAt":{comment ="更新时间";}break;
            }
        }else{
            Validate.notNull(commentAnnotation, "AMS自定义类注释不能为空!涉及类:"+amsClazzConfig.responseClass.getName()+",涉及字段:"+entityField.getName());
            comment = commentAnnotation.value();
        }
        Validate.notNull(comment, "AMS自定义类注释不能为空!涉及类:"+amsClazzConfig.requestClass.getName()+",涉及字段:"+entityField.getName());
        if(comment.contains("(")){
            JSONObject resourceField = (JSONObject) flowContext.startFlow(new GetSelectResourceFieldFlow())
                    .putCurrentCompositeFlowData("comment", comment)
                    .execute()
                    .checkData("resourceField");
            matchBlock.getJSONObject("resourceFields").put(entityField.getName(), resourceField);
        }else{
            JSONObject resourceField = (JSONObject) flowContext.startFlow(new GetClazzBasicResourceFieldFlow())
                    .putCurrentCompositeFlowData("comment", comment)
                    .putCurrentCompositeFlowData("entityField", entityField)
                    .execute()
                    .checkData("resourceField");
            matchBlock.getJSONObject("resourceFields").put(entityField.getName(), resourceField);
        }
    }

    private void setOperationField(Field entityField, FlowContext flowContext){
        AMSClazzConfig amsClazzConfig = (AMSClazzConfig) flowContext.checkData("amsClazzConfig");
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        if(Modifier.isTransient(entityField.getModifiers())){
            return;
        }
        if(null!=entityField.getAnnotation(Ignore.class)){
            return;
        }
        String comment = null;
        Comment commentAnnotation = entityField.getAnnotation(Comment.class);
        if(null==commentAnnotation){
            switch (entityField.getName()){
                case "id":{comment ="自增id";}break;
                case "createdAt":{comment ="创建时间";}break;
                case "updatedAt":{comment ="更新时间";}break;
            }
        }else{
            Validate.notNull(commentAnnotation, "AMS自定义类注释不能为空!涉及类:"+amsClazzConfig.responseClass.getName()+",涉及字段:"+entityField.getName());
            comment = commentAnnotation.value();
        }
        Validate.notNull(comment, "AMS自定义类注释不能为空!涉及类:"+amsClazzConfig.responseClass.getName()+",涉及字段:"+entityField.getName());
        if(comment.contains("(")){
            JSONObject operationField = (JSONObject) flowContext.startFlow(new GetSelectResourceFieldFlow())
                    .next(new GetOperationFieldFlow())
                    .putCurrentCompositeFlowData("comment", comment)
                    .execute()
                    .checkData("operationField");
            matchBlock.getJSONObject("operationFields").put(entityField.getName(), operationField);
        }else{
            JSONObject operationField = (JSONObject) flowContext.startFlow(new GetClazzBasicResourceFieldFlow())
                    .next(new GetOperationFieldFlow())
                    .putCurrentCompositeFlowData("comment", comment)
                    .putCurrentCompositeFlowData("entityField", entityField)
                    .execute()
                    .checkData("operationField");
            matchBlock.getJSONObject("operationFields").put(entityField.getName(), operationField);
        }
    }
}
