package cn.schoolwow.ams.module.initial.flow.set.field.common;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;

public class GetOperationFieldFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        JSONObject resourceField = (JSONObject) flowContext.checkData("resourceField");
        if("textarea".equalsIgnoreCase(resourceField.getString("type"))){
            resourceField.put("type", "text");
        }

        JSONObject operationField = new JSONObject();
        operationField.put("slot", "searchs");
        operationField.put("type", "field");
        operationField.put("label", resourceField.getString("label"));
        operationField.put("field", resourceField);
        operationField.put("info", resourceField.getString("info"));
        flowContext.putReturnData("operationField", operationField);
    }

    @Override
    public String name() {
        return "获取operations字段";
    }

}
