package cn.schoolwow.ams.module.initial.flow.set.operation;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class SetCopyFieldButtonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        Map<String,String> copyFieldCommentMap = (Map<String, String>) flowContext.getData("copyFieldCommentMap");
        if(null==copyFieldCommentMap||copyFieldCommentMap.isEmpty()){
            return;
        }
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        for(Map.Entry<String,String> entry:copyFieldCommentMap.entrySet()){
            Validate.notEmpty(entry.getKey(), "复制字段名称不能为空!");
            Validate.notEmpty(entry.getValue(), "复制字段按钮名称不能为空!");

            JSONObject operationField = new JSONObject();
            {
                operationField.put("type", "button");
                operationField.put("label", entry.getValue());
                {
                    JSONObject props = new JSONObject();
                    props.put("type", "primary");
                    operationField.put("props", props);
                }
                operationField.put("event", "copyField:"+entry.getKey());
            }
            matchBlock.getJSONObject("operationFields").put("copy|"+entry.getKey().replace(",","|"), operationField);
        }
    }

    @Override
    public String name() {
        return "设置页面字段复制按钮";
    }

}
