package cn.schoolwow.ams.module.initial.flow.set.operation;

import cn.schoolwow.ams.domain.listener.select.AMSRemoteSelect;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SetRemoteSelectOperationFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        AMSRemoteSelect amsRemoteSelect = (AMSRemoteSelect) flowContext.checkData("amsRemoteSelect");
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        JSONObject operationField = new JSONObject();
        operationField.put("slot", "searchs");
        operationField.put("type", "field");
        operationField.put("label", amsRemoteSelect.label);
        {
            JSONObject field = new JSONObject();
            field.put("BASE", "SELECT_REMOTE");
            field.put("type", "select");
            field.put("info", amsRemoteSelect.label);
            {
                JSONObject props = new JSONObject();
                props.put("placeholder", "请选择"+amsRemoteSelect.label);
                props.put("clearable", true);
                props.put("multiple", false);
                field.put("props", props);
            }
            {
                JSONObject remoteConfig = new JSONObject();
                remoteConfig.put("dataPath", "data");
                remoteConfig.put("action", "/ams/api/"+projectName+"/remoteSelect/"+amsRemoteSelect.type
                        +(StringUtils.isNotBlank(amsRemoteSelect.parameter)?"?"+amsRemoteSelect.parameter:""));
                remoteConfig.put("queryKey", "name");
                remoteConfig.put("isCache", false);
                field.put("remoteConfig", remoteConfig);
            }
            if(StringUtils.isNotBlank(amsRemoteSelect.defaultValue)){
                field.put("default", amsRemoteSelect.defaultValue);
            }
            operationField.put("field", field);
        }
        matchBlock.getJSONObject("operationFields").put(amsRemoteSelect.name, operationField);
    }

    @Override
    public String name() {
        return "设置列表远程下拉框选项";
    }

}
