package cn.schoolwow.ams.module.initial.flow.set.resource;

import cn.schoolwow.ams.domain.listener.operation.AMSOperationButton;
import cn.schoolwow.ams.domain.listener.operation.AMSOperationPosition;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetAMSOperationButtonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<AMSOperationButton> amsOperationButtonList = (List<AMSOperationButton>) flowContext.getData("amsOperationButtonList");
        if(null==amsOperationButtonList||amsOperationButtonList.isEmpty()){
            return;
        }
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");
        String className = (String) flowContext.checkData("className");

        JSONObject operationFields = matchBlock.getJSONObject("operationFields");
        for(AMSOperationButton amsOperationButton:amsOperationButtonList){
            Validate.notEmpty(amsOperationButton.label, "按钮名称不能为空!涉及类名:"+className);
            Validate.notEmpty(amsOperationButton.methodName, "按钮方法名不能为空!涉及类名:"+className);
            Validate.notNull(amsOperationButton.handleOperation, "按钮处理逻辑不能为空!涉及类名:"+className);

            if(AMSOperationPosition.None.equals(amsOperationButton.position)){
                continue;
            }
            if(AMSOperationPosition.MultipleSelect.equals(amsOperationButton.position)){
                JSONObject operationField = new JSONObject();
                operationField.put("position", amsOperationButton.position.name());
                setOperationField(operationField, amsOperationButton,true);
                operationFields.put("multipleSelect_"+amsOperationButton.methodName, operationField);
            }
            JSONObject singleOperationField = new JSONObject();
            singleOperationField.put("position", amsOperationButton.position.name());
            setOperationField(singleOperationField, amsOperationButton,false);
            operationFields.put(amsOperationButton.methodName, singleOperationField);

            setItemOperation(amsOperationButton, flowContext);
        }
    }

    @Override
    public String name() {
        return "设置列表操作按钮";
    }

    private void setOperationField(JSONObject operationField, AMSOperationButton amsOperationButton, boolean checkMultiple) throws Exception {
        operationField.put("type", "button");
        operationField.put("label", amsOperationButton.label);
        {
            JSONObject props = new JSONObject();
            props.put("type", "primary");
            if(null!=amsOperationButton.propOperation){
                amsOperationButton.propOperation.props(props);
            }
            operationField.put("props", props);
        }
        operationField.put("event", "confirm:确认"+amsOperationButton.label+"吗? sendRequest:"+amsOperationButton.methodName+" list:1");

        operationField.put("slot", "");
        if(AMSOperationPosition.RightTop.equals(amsOperationButton.position)){
            operationField.put("slot", "rightTop");
        }
        if(checkMultiple){
            if(AMSOperationPosition.MultipleSelect.equals(amsOperationButton.position)){
                operationField.put("slot", "multipleSelect");
                operationField.put("label", "批量"+amsOperationButton.label);
                operationField.put("event", "confirm:确认批量"+amsOperationButton.label+"吗? sendRequest:"+amsOperationButton.methodName+" list:1");
            }
        }
    }

    private void setItemOperation(AMSOperationButton amsOperationButton, FlowContext flowContext){
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        if(!matchBlock.containsKey("itemOperationMap")){
            matchBlock.put("itemOperationMap", new JSONObject());
        }
        JSONObject itemOperation = new JSONObject();
        itemOperation.put("fieldNameList", amsOperationButton.fieldNameList);
        itemOperation.put("searchFieldNameList", amsOperationButton.searchFieldNameList);

        JSONObject itemOperationMap = matchBlock.getJSONObject("itemOperationMap");
        itemOperationMap.put(amsOperationButton.methodName, itemOperation);
    }
}
