package cn.schoolwow.ams.module.initial.flow.set.resource;

import cn.schoolwow.ams.domain.listener.dialog.AMSDialog;
import cn.schoolwow.ams.module.initial.flow.set.dialog.SetAddButtonFlow;
import cn.schoolwow.ams.module.initial.flow.set.dialog.SetDeleteButtonFlow;
import cn.schoolwow.ams.module.initial.flow.set.dialog.SetUpdateButtonFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class SetTableDialogFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        AMSDialog amsDialog = (AMSDialog) flowContext.getData("amsDialog");

        if(null==amsDialog){
            return;
        }
        JSONObject matchBlock = (JSONObject) flowContext.checkData("matchBlock");

        JSONObject itemDialog = new JSONObject();
        itemDialog.put("jsonFieldNameList", amsDialog.jsonFieldNameList);
        matchBlock.put("itemDialog", itemDialog);

        flowContext.startFlow(new SetAddButtonFlow())
                .next(new SetUpdateButtonFlow())
                .next(new SetDeleteButtonFlow())
                .putCurrentCompositeFlowData("amsDialog", amsDialog)
                .execute();
    }

    @Override
    public String name() {
        return "配置列表增删改按钮";
    }

}
