package cn.schoolwow.ams.module.initial.flow.set.resource;

import cn.schoolwow.ams.domain.listener.routerpush.AMSRouterPush;
import cn.schoolwow.ams.module.initial.flow.set.operation.SetRouterPushButtonFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class SetTableRouterPushFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<AMSRouterPush> amsRouterPushList = (List<AMSRouterPush>) flowContext.getData("amsRouterPushList");
        if(null==amsRouterPushList||amsRouterPushList.isEmpty()){
            return;
        }
        String className = (String) flowContext.checkData("className");

        for(AMSRouterPush amsRouterPush:amsRouterPushList){
            //校验
            {
                Validate.notEmpty(amsRouterPush.name, "页面跳转按钮名称不能为空!涉及类名:"+className);
                Validate.notEmpty(amsRouterPush.label, "页面跳转显示名称不能为空!涉及类名:"+className);
                Validate.notEmpty(amsRouterPush.path, "页面跳转路径不能为空!涉及类名:"+className);
                Validate.notEmpty(amsRouterPush.fieldNameMap, "页面跳转参数映射不能为空!涉及类名:"+className);
            }

            flowContext.startFlow(new SetRouterPushButtonFlow())
                    .putCurrentCompositeFlowData("amsRouterPush", amsRouterPush)
                    .execute();
        }
    }

    @Override
    public String name() {
        return "设置跳转页面按钮";
    }

}
