package cn.schoolwow.ams.module.initial.service;

import cn.schoolwow.ams.module.initial.flow.get.GetAMSTableConfigListFlow;
import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import cn.schoolwow.ams.module.initial.flow.get.*;

@Service
public class SetAMSInfoCompositeBusiness implements CompositeBusinessFlow {
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
        quickFlowExecutor.next(applicationContext.getBean(SetScriptPathFlow.class))
                .next(applicationContext.getBean(GetAMSTableConfigListFlow.class))
                .next(applicationContext.getBean(GetAMSClazzConfigListFlow.class))
                .next(applicationContext.getBean(GetBlockArrayFlow.class))
                .next(applicationContext.getBean(SetAMSTableConfigFlow.class))
                .next(applicationContext.getBean(SetAMSClazzConfigFlow.class));
    }

    @Override
    public String name() {
        return "ams信息初始化";
    }
}
