package cn.schoolwow.ams.module.listener.operation.flow;

import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.domain.listener.clazz.DeleteClazzListener;
import cn.schoolwow.ams.domain.listener.table.DeleteTable;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

public class DeleteFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");

        if("clazz".equalsIgnoreCase(daoName)){
            getByClazz(flowContext);
        }else{
            getByTable(flowContext);
        }
    }

    @Override
    public String name() {
        return "delete操作";
    }

    private void getByTable(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        Map<String, Object> amsListConditionMap = (Map<String, Object>) flowContext.checkData("amsListConditionMap");
        AMSListener amsListener = (AMSListener) flowContext.checkData("amsListener");
        DeleteTable deleteTable = (DeleteTable) flowContext.getData("deleteTable");
        Entity entity = (Entity) flowContext.getData("entity");

        JSONObject amsListCondition = JSON.parseObject(JSON.toJSONString(amsListConditionMap));
        DAO dao = amsListener.getDAO(daoName);
        Condition condition = null;
        if(null==entity){
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
        }else{
            condition = dao.query(entity.clazz);
        }
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);

        if(null!=deleteTable){
            deleteTable.beforeDelete(condition, amsListCondition);
        }
        condition.clone().execute().delete();
        if(null!=deleteTable){
            deleteTable.afterDelete(condition, amsListCondition);
        }
    }

    private void getByClazz(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String tableName = (String) flowContext.checkData("tableName");
        Map<String, Object> amsListConditionMap = (Map<String, Object>) flowContext.checkData("amsListConditionMap");
        DeleteClazzListener deleteClazzListener = (DeleteClazzListener) flowContext.getData("deleteClazzListener");

        if(null==deleteClazzListener){
            throw new IllegalArgumentException("未匹配到Clazz选项!方法:Delete,项目名:"+projectName+",类型:"+tableName);
        }
        deleteClazzListener.delete(amsListConditionMap);
    }
}
