package cn.schoolwow.ams.module.listener.operation.flow;

import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.domain.listener.clazz.ListClazzListener;
import cn.schoolwow.ams.domain.listener.table.ListTable;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.util.Map;

public class ListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");

        if("clazz".equalsIgnoreCase(daoName)){
            getByClazz(flowContext);
        }else{
            getByTable(flowContext);
        }
    }

    @Override
    public String name() {
        return "list操作";
    }

    private void getByTable(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        Map<String, Object> amsListConditionMap = (Map<String, Object>) flowContext.checkData("amsListConditionMap");
        AMSListener amsListener = (AMSListener) flowContext.checkData("amsListener");
        ListTable listTable = (ListTable) flowContext.getData("listTable");
        Entity entity = (Entity) flowContext.getData("entity");

        JSONObject amsListCondition = JSON.parseObject(JSON.toJSONString(amsListConditionMap));
        DAO dao = amsListener.getDAO(daoName);
        Condition condition;
        if(null==entity){
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
            for(Property property:entity.properties){
                condition.addColumn(property.column + " " + StringUtil.underline2Camel(property.column));
            }
        }else{
            condition = dao.query(entity.clazz);
        }
        if(null!=listTable){
            listTable.beforeExecuteCondition(condition, amsListCondition);
        }
        AMSUtil.pageAndSort(condition, amsListCondition);
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        PageVo pageVo = condition.execute().getPagingList();
        if(null!=listTable){
            listTable.afterExecuteCondition(condition, amsListCondition, pageVo);
        }
        JSONObject amsPagingList = AMSUtil.getAMSPagingList(pageVo);
        flowContext.putData("amsPagingList", amsPagingList);
    }

    private void getByClazz(FlowContext flowContext) throws Exception {
        String projectName = (String) flowContext.checkData("projectName");
        String tableName = (String) flowContext.checkData("tableName");
        Map<String, Object> amsListConditionMap = (Map<String, Object>) flowContext.checkData("amsListConditionMap");
        ListClazzListener listClazzListener = (ListClazzListener) flowContext.getData("listClazzListener");

        if(null==listClazzListener){
            throw new IllegalArgumentException("未匹配到Clazz选项!方法:List,项目名:"+projectName+",类型:"+tableName);
        }

        JSONObject amsPagingList = listClazzListener.list(amsListConditionMap);
        flowContext.putData("amsPagingList", amsPagingList);
    }
}
