package cn.schoolwow.ams.module.listener.operation.flow.common;

import cn.schoolwow.ams.domain.AMSClazzConfig;
import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.domain.AMSTableConfig;
import cn.schoolwow.ams.domain.listener.clazz.AMSClazzListener;
import cn.schoolwow.ams.domain.listener.table.AMSTableListener;
import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.Collection;
import java.util.List;

public class SetAMSTableListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String daoName = (String) flowContext.checkData("daoName");

        switch (daoName){
            case "clazz":{
                matchClazz(flowContext);
            }break;
            default:{
                matchTable(flowContext);
            }break;
        }
    }

    @Override
    public String name() {
        return "根据数据库名设置amsTableListener";
    }

    private void matchTable(FlowContext flowContext){
        List<AMSTableConfig> amsTableConfigList = (List<AMSTableConfig>) flowContext.getData("amsTableConfigList");
        if(null==amsTableConfigList||amsTableConfigList.isEmpty()){
            flowContext.brokenCurrentFlow("无Table匹配监听器");
            return;
        }
        String projectName = (String) flowContext.checkData("projectName");
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");

        for(AMSTableConfig amsTableConfig:amsTableConfigList){
            AMSTableListener amsTableListener = amsTableConfig.amsTableListener;
            if(null==amsTableListener){
                continue;
            }
            if(!projectName.equalsIgnoreCase(amsTableConfig.projectName)){
                continue;
            }
            if(!daoName.equalsIgnoreCase(amsTableConfig.daoName)){
                continue;
            }
            if(!amsTableConfig.entity.clazz.getSimpleName().equalsIgnoreCase(tableName)
                    &&!amsTableConfig.tableName.equalsIgnoreCase(tableName)){
                continue;
            }
            flowContext.putTemporaryData("entity", amsTableConfig.entity);

            flowContext.putTemporaryData("amsTableConfig", amsTableListener);
            flowContext.putTemporaryData("listTable", amsTableListener.listTable);
            flowContext.putTemporaryData("createTable", amsTableListener.createTable);
            flowContext.putTemporaryData("editTable", amsTableListener.editTable);
            flowContext.putTemporaryData("deleteTable", amsTableListener.deleteTable);
            flowContext.brokenCurrentFlow("匹配到Table监听器");
        }
    }

    private void matchClazz(FlowContext flowContext){
        List<AMSClazzConfig> amsClazzConfigList = (List<AMSClazzConfig>) flowContext.getData("amsClazzConfigList");
        if(null==amsClazzConfigList||amsClazzConfigList.isEmpty()){
            flowContext.brokenCurrentFlow("无Clazz匹配监听器");
            return;
        }
        String projectName = (String) flowContext.checkData("projectName");
        String tableName = (String) flowContext.checkData("tableName");

        for(AMSClazzConfig amsClazzConfig:amsClazzConfigList){
            AMSClazzListener amsClazzListener = amsClazzConfig.amsClazzListener;
            if(null==amsClazzListener){
                continue;
            }
            if(!projectName.equalsIgnoreCase(amsClazzConfig.projectName)){
                continue;
            }
            if(!tableName.equalsIgnoreCase(amsClazzConfig.clazzName)){
                continue;
            }
            flowContext.putTemporaryData("amsClazzConfig", amsClazzListener);
            flowContext.putTemporaryData("listClazzListener", amsClazzListener.listClazzListener);
            flowContext.putTemporaryData("createClazzListener", amsClazzListener.createClazzListener);
            flowContext.putTemporaryData("editClazzListener", amsClazzListener.editClazzListener);
            flowContext.putTemporaryData("deleteClazzListener", amsClazzListener.deleteClazzListener);
            flowContext.brokenCurrentFlow("匹配到Clazz监听器");
        }
    }

    private Entity getEntity(FlowContext flowContext){
        String daoName = (String) flowContext.checkData("daoName");
        String tableName = (String) flowContext.checkData("tableName");
        AMSListener amsListener = (AMSListener) flowContext.checkData("amsListener");

        DAO dao = amsListener.getDAO(daoName);
        Collection<Entity> entityCollection = dao.getEntityMap().values();
        for(Entity entity:entityCollection){
            if(entity.clazz.getSimpleName().equalsIgnoreCase(tableName)){
                return entity;
            }
        }
        return null;
    }
}
