package cn.schoolwow.ams.module.listener.operation.kit;

import cn.schoolwow.ams.domain.listener.operation.AMSDispatcherService;
import cn.schoolwow.ams.domain.listener.select.AMSRemoteSelect;
import cn.schoolwow.ams.module.listener.operation.flow.*;
import cn.schoolwow.ams.module.listener.operation.flow.common.SetAMSListenerFlow;
import cn.schoolwow.ams.module.listener.operation.flow.common.SetAMSTableListenerFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DefaultAMSDispatcherService implements AMSDispatcherService {
    private QuickFlow amsFlow;
    
    public DefaultAMSDispatcherService(QuickFlow amsFlow) {
        this.amsFlow = amsFlow;
    }

    @Override
    public JSONObject list(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        FlowContext flowContext = amsFlow.startFlow(new ListFlow())
                .beforeFlowList(Arrays.asList(new SetAMSListenerFlow(), new SetAMSTableListenerFlow()))
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("amsListConditionMap", amsListConditionMap)
                .execute();
        JSONObject amsPagingList = (JSONObject) flowContext.checkData("amsPagingList");
        return amsPagingList;
    }

    @Override
    public void create(String projectName, String daoName, String tableName, JSONObject createEntity) {
        amsFlow.startFlow(new CreateFlow())
                .beforeFlowList(Arrays.asList(new SetAMSListenerFlow(), new SetAMSTableListenerFlow()))
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("createEntity", createEntity)
                .execute();
    }

    @Override
    public void edit(String projectName, String daoName, String tableName, JSONObject updateEntity) {
        amsFlow.startFlow(new EditFlow())
                .beforeFlowList(Arrays.asList(new SetAMSListenerFlow(), new SetAMSTableListenerFlow()))
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("updateEntity", updateEntity)
                .execute();
    }

    @Override
    public void delete(String projectName, String daoName, String tableName, Map<String, Object> amsListConditionMap) {
        amsFlow.startFlow(new DeleteFlow())
                .beforeFlowList(Arrays.asList(new SetAMSListenerFlow(), new SetAMSTableListenerFlow()))
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("amsListConditionMap", amsListConditionMap)
                .execute();
    }

    @Override
    public JSONObject operationDispatcher(String projectName, String daoName, String tableName, String methodName, JSONObject requestBody) {
        FlowContext flowContext = amsFlow.startFlow(new OperationDispatcherFlow())
                .beforeFlowList(Arrays.asList(new SetAMSListenerFlow(), new SetAMSTableListenerFlow()))
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("daoName", daoName)
                .putCurrentCompositeFlowData("tableName", tableName)
                .putCurrentCompositeFlowData("methodName", methodName)
                .putCurrentCompositeFlowData("requestBody", requestBody)
                .execute();
        JSONObject response = (JSONObject) flowContext.getData("response");
        return response;
    }

    @Override
    public JSONArray remoteSelect(String projectName, String type, Map<String, String> amsListConditionMap) {
        List<AMSRemoteSelect> remoteSelectContextList = (List<AMSRemoteSelect>) amsFlow.getContextData("remoteSelectContextList");
        for(AMSRemoteSelect amsRemoteSelect:remoteSelectContextList){
            if(amsRemoteSelect.type.equalsIgnoreCase(type)){
                return amsRemoteSelect.getRemoteOption.getRemoteOption(amsListConditionMap);
            }
        }
        throw new IllegalArgumentException("未匹配到下拉框选项!项目名:"+projectName+",类型:"+type);
    }

}
