package cn.schoolwow.ams.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ReflectionUtil {
    public static Object getInstanceFieldValue(Object instance, String fieldName) {
        try {
            Field field = searchFieldFromSuperClass(fieldName, instance.getClass());
            Object value = field.get(instance);
            return value;
        }catch (Exception e){
            throw new RuntimeException(e);
        }
    }

    public static Field[] getFieldsFromSuperClass(Class clazz){
        List<Field> fieldList = new ArrayList<>();
        while(null!=clazz){
            Field[] fields = clazz.getDeclaredFields();
            Field.setAccessible(fields, true);
            fieldList.addAll(Arrays.asList(fields));
            clazz = clazz.getSuperclass();
        }
        return fieldList.toArray(new Field[0]);
    }

    public static Field searchFieldFromSuperClass(String fieldName, Class clazz){
        String initialClassName = clazz.getName();
        while(null!=clazz.getSuperclass()){
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            } catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new IllegalArgumentException("字段不存在!字段名:"+fieldName+",类名:"+initialClassName);
    }
}
