/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.module.listener.operation.flow;

import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.domain.listener.clazz.ListClazzListener;
import cn.schoolwow.ams.domain.listener.table.ListTable;
import cn.schoolwow.ams.util.AMSUtil;
import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickdao.domain.entity.Entity;
import cn.schoolwow.quickdao.domain.entity.Property;
import cn.schoolwow.quickdao.util.StringUtil;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;

public class ListFlow
implements BusinessFlow {
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        String daoName = (String)flowContext.checkData("daoName");
        if ("clazz".equalsIgnoreCase(daoName)) {
            this.getByClazz(flowContext);
        } else {
            this.getByTable(flowContext);
        }
    }

    public String name() {
        return "list\u64cd\u4f5c";
    }

    private void getByTable(FlowContext flowContext) throws Exception {
        Condition condition;
        String daoName = (String)flowContext.checkData("daoName");
        String tableName = (String)flowContext.checkData("tableName");
        Map amsListConditionMap = (Map)flowContext.checkData("amsListConditionMap");
        AMSListener amsListener = (AMSListener)flowContext.checkData("amsListener");
        ListTable listTable = (ListTable)flowContext.getData("listTable");
        Entity entity = (Entity)flowContext.getData("entity");
        JSONObject amsListCondition = JSON.parseObject((String)JSON.toJSONString((Object)amsListConditionMap));
        DAO dao = amsListener.getDAO(daoName);
        if (null == entity) {
            entity = dao.getDatabaseEntity(tableName);
            condition = dao.query(tableName);
            for (Property property : entity.properties) {
                condition.addColumn(new String[]{property.column + " " + StringUtil.underline2Camel((String)property.column)});
            }
        } else {
            condition = dao.query(entity.clazz);
        }
        if (null != listTable) {
            listTable.beforeExecuteCondition(condition, amsListCondition);
        }
        AMSUtil.pageAndSort(condition, amsListCondition);
        AMSUtil.addCompositeQuery(entity, condition, amsListCondition);
        PageVo pageVo = condition.execute().getPagingList();
        if (null != listTable) {
            listTable.afterExecuteCondition(condition, amsListCondition, pageVo);
        }
        JSONObject amsPagingList = AMSUtil.getAMSPagingList(pageVo);
        flowContext.putData("amsPagingList", (Object)amsPagingList);
    }

    private void getByClazz(FlowContext flowContext) throws Exception {
        String projectName = (String)flowContext.checkData("projectName");
        String tableName = (String)flowContext.checkData("tableName");
        Map amsListConditionMap = (Map)flowContext.checkData("amsListConditionMap");
        ListClazzListener listClazzListener = (ListClazzListener)flowContext.getData("listClazzListener");
        if (null == listClazzListener) {
            throw new IllegalArgumentException("\u672a\u5339\u914d\u5230Clazz\u9009\u9879!\u65b9\u6cd5:List,\u9879\u76ee\u540d:" + projectName + ",\u7c7b\u578b:" + tableName);
        }
        JSONObject amsPagingList = listClazzListener.list(amsListConditionMap);
        flowContext.putData("amsPagingList", (Object)amsPagingList);
    }
}

