/*
 * Decompiled with CFR 0.152.
 */
package cn.schoolwow.ams.module.initial.flow;

import cn.schoolwow.ams.domain.AMSGlobalConfig;
import cn.schoolwow.ams.domain.AMSListener;
import cn.schoolwow.ams.module.initial.flow.ClearAMSInfoFlow;
import cn.schoolwow.ams.module.initial.service.SetAMSInfoCompositeBusiness;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class GetConfigFlow
implements BusinessFlow {
    @Autowired(required=false)
    private AMSGlobalConfig amsGlobalConfig;
    @Autowired
    private ApplicationContext applicationContext;

    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        this.refresh(flowContext);
        this.getFromCache(flowContext);
        this.getConfig(flowContext);
    }

    public String name() {
        return "\u83b7\u53d6ams\u9875\u9762\u914d\u7f6e\u4fe1\u606f";
    }

    private void refresh(FlowContext flowContext) {
        if (null != this.amsGlobalConfig && this.amsGlobalConfig.shouldRefresh()) {
            flowContext.startFlow((BusinessFlow)this.applicationContext.getBean(ClearAMSInfoFlow.class)).next((CompositeBusinessFlow)this.applicationContext.getBean(SetAMSInfoCompositeBusiness.class));
        }
    }

    private void getFromCache(FlowContext flowContext) {
        String projectName = (String)flowContext.checkData("projectName");
        Map projectNameConfigMap = (Map)flowContext.getData("projectNameConfigMap", new HashMap());
        if (projectNameConfigMap.containsKey(projectName)) {
            JSONObject config = (JSONObject)projectNameConfigMap.get(projectName);
            flowContext.putTemporaryData("config", (Object)config);
            flowContext.brokenCurrentFlow("\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6");
        }
    }

    private void getConfig(FlowContext flowContext) {
        String projectName = (String)flowContext.checkData("projectName");
        Map projectNameConfigMap = (Map)flowContext.getData("projectNameConfigMap", new HashMap());
        JSONArray blocks = (JSONArray)flowContext.getData("blocks", (Object)new JSONArray());
        List scriptPathList = (List)flowContext.getData("scriptPathList", new ArrayList());
        Collection amsListenerList = (Collection)flowContext.checkData("amsListenerList");
        for (AMSListener amsListener : amsListenerList) {
            if (!amsListener.projectName().equalsIgnoreCase(projectName)) continue;
            JSONObject config = new JSONObject();
            config.put("projectName", (Object)amsListener.projectName());
            config.put("applicationName", (Object)amsListener.applicationName());
            JSONObject blockMap = new JSONObject();
            for (int i = 0; i < blocks.size(); ++i) {
                JSONObject block = blocks.getJSONObject(i);
                if (!projectName.equalsIgnoreCase(block.getString("projectName"))) continue;
                blockMap.put(block.getString("uniqueKey"), (Object)block);
            }
            config.put("blockMap", (Object)blockMap);
            ArrayList<String> currentProjectScriptPathList = new ArrayList<String>();
            for (String scriptPath : scriptPathList) {
                if (!scriptPath.startsWith("/ams/" + projectName) && !scriptPath.startsWith("/ams/commonOperation")) continue;
                currentProjectScriptPathList.add(scriptPath);
            }
            config.put("scriptPathList", currentProjectScriptPathList);
            config.put("extraData", (Object)amsListener.extraData());
            projectNameConfigMap.put(projectName, config);
            flowContext.putTemporaryData("config", (Object)config);
            return;
        }
        throw new IllegalArgumentException("\u6839\u636e\u9879\u76ee\u540d\u672a\u627e\u5230\u5339\u914d\u7684\u9879\u76ee\u914d\u7f6e!\u9879\u76ee\u540d:" + projectName);
    }
}

