function setClipBoard(value) {
    let e = document.getElementById("clipboard");
    e.value = value;
    e.select();
    document.execCommand("copy");
}

function setClipBoardPlain(value) {
    value = value.replace("\r\n","\n");
    setClipBoard(value);
}

ams.utils.getIdList = function (params, idField) {
    if (typeof idField == "undefined") {
        idField = "id";
    }
    let ids = [];
    let array = params.$prevReturn;
    if (Array.isArray(array)) {
        for (let i = 0; i < array.length; i++) {
            ids.push(array[i][idField]);
        }
    } else {
        let id = array[idField];
        if (null != id && "" !== id) {
            ids.push(id);
        }
    }
    return ids;
};

ams.utils.getIdsString = function (params, idField) {
    let idList = ams.utils.getIdList(params, idField);
    return idList.join(",");
};

ams.utils.getDataList = function (params) {
    let returnArray = [];
    let array = params.$prevReturn;
    if (Array.isArray(array)) {
        for (let i = 0; i < array.length; i++) {
            returnArray.push(array[i]);
        }
    } else {
        returnArray.push(array);
    }
    return returnArray;
};

ams.utils.sendRequest = function (activeBlock, option, message) {
    let prefix = activeBlock.resource.api.prefix;
    return ams.utils.sendRequestWithPrefix(activeBlock, prefix, option, message);
};

ams.utils.sendRequestWithResponse = function (activeBlock, option, responseFunction) {
    let prefix = activeBlock.resource.api.prefix;
    option.url = prefix + option.url;
    activeBlock.showLoading();
    return ams.request(option).then((response) => {
        if (response.data.code !== 0) {
            activeBlock.$message.error(response.data.msg);
            return;
        }
        responseFunction(response.data);
    }).finally(() => {
        activeBlock.hideLoading();
    });
};

ams.utils.sendRequestWithPrefix = function (activeBlock, prefix, option, message) {
    option.url = prefix + option.url;
    activeBlock.showLoading();
    return ams.request(option).then((response) => {
        if (response.data.code !== 0) {
            activeBlock.$message.error(response.data.msg);
            return;
        }
        if(option["copyToClipBoard"]){
            let data = response.data.data;
            setClipBoard(JSON.stringify(data));
        }
        activeBlock.$message.success(message);
    }).finally(() => {
        activeBlock.hideLoading();
    });
};

ams.utils.sendRequestWithTableName = function (activeBlock, projectName, tableName, option, message) {
    let resourceBlock = ams.utils.getBlockByTableName(projectName, tableName);
    let resource = ams.resources[resourceBlock["resource"]];
    let prefix = resource.api.prefix;
    return ams.utils.sendRequestWithPrefix(activeBlock, prefix, option, message);
};

ams.utils.getResourceFields = function(block, fieldNames){
    let fields = block.resource.fields;
    if(typeof(fieldNames)=="undefined"||fieldNames.length===0){
        return fields;
    }
    let returnFields = {};
    for(let i=0;i<fieldNames.length;i++){
        let fieldName = fieldNames[i];
        returnFields[fieldName] = fields[fieldName];
    }
    return returnFields;
};

ams.utils.disabledResourceFields = function(fields, disabledFieldNames){
    for(let i=0;i<disabledFieldNames.length;i++){
        let field = fields[disabledFieldNames[i]];
        if(!field.hasOwnProperty("props")){
            field["props"] = {
                "disabled":true
            }
        }else{
            field["props"]["disabled"] = true;
        }
    }
};

ams.utils.addItemDialog = function(block, createApi, fields, addOption){
    let prefix = block.resource.api.prefix;
    let dialogOption = {
        "resource": {
            "api": {
                "prefix": prefix,
                "create": createApi,
            },
            "fields": fields
        }
    };
    if(typeof(addOption)!="undefined"){
        addOption["path"] = createApi;
        dialogOption.resource.api.create = addOption;
    }
    return block.callAction("@addItemDialog", dialogOption);
};

ams.utils.editItemDialog = function(block, updateApi, fields, editOption){
    let prefix = block.resource.api.prefix;
    let dialogOption = {
        "resource": {
            "api": {
                "prefix": prefix,
                "update": updateApi,
            },
            "fields": fields
        }
    };
    if(typeof(editOption)!="undefined"){
        editOption["path"] = updateApi;
        dialogOption.resource.api.update = editOption;
    }
    return block.callAction("@editItemDialog", dialogOption);
};

ams.utils.getBlockByTableName = function(projectName, tableName){
    for(let prop in ams.blocks){
        let tokens = prop.split("|");
        let blockProjectName = tokens[0];
        let blockDAOName = tokens[1];
        let blockTableName = tokens[2];
        if(blockProjectName===projectName&&blockTableName===tableName){
            return ams.blocks[prop];
        }
    }
    return null;
};