function SetOperationShowFunctionFlow(context){
    const blockOperationContext = quickams.checkData(context, "blockOperationContext");
    const operationButton = quickams.checkData(context, "operationButton");

    if(blockOperationContext["showButtonOptionList"].length===0){
        return;
    }
    const showButtonOptionList = blockOperationContext["showButtonOptionList"];
    operationButton["show"] = function(row){
        for(let i=0;i<showButtonOptionList.length;i++){
            const showButtonOption = showButtonOptionList[i];
            const actualValue = row[showButtonOption["key"]];
            const expectValue = showButtonOption["value"];
            const operator = showButtonOption["operator"];
            switch (operator){
                case "=":{
                    if(actualValue!==expectValue){
                        return false;
                    }
                }break;
                case ">":{
                    if(actualValue<=expectValue){
                        return false;
                    }
                }break;
                case ">=":{
                    if(actualValue<expectValue){
                        return false;
                    }
                }break;
                case "<":{
                    if(actualValue>=expectValue){
                        return false;
                    }
                }break;
                case "<=":{
                    if(actualValue>expectValue){
                        return false;
                    }
                }break;
                case "null":{
                    if(null!=actualValue){
                        return false;
                    }
                }break;
                case "notNull":{
                    if(null==actualValue){
                        return false;
                    }
                }break;
                case "in":{
                    if(expectValue.indexOf(actualValue)<0){
                        return false;
                    }
                }break;
                case "notIn":{
                    if(expectValue.indexOf(actualValue)>=0){
                        return false;
                    }
                }break;
            }
        }
        return true;
    }
}