function SetSelectResourceFieldFlow(context){
    const fieldContext = quickams.checkData(context, "fieldContext");

    const label = quickams.checkData(fieldContext, "label");
    if(label.indexOf("(")<0||label.indexOf(")")<0){
        throw new Error("字段注释异常!注释:"+label);
    }

    let options = {};
    const selectComment = label.substring(label.indexOf("(")+1, label.indexOf(")"));
    let tokens = selectComment.split(",");
    for(let i=0;i<tokens.length;i++){
        const commaIndex = tokens[i].indexOf(":");
        if(commaIndex<0){
            throw new Error("字段注释异常!注释:"+tokens[i]);
        }
        const key = tokens[i].substring(0, commaIndex);
        const value = tokens[i].substring(commaIndex+1);
        options[key] = value;
    }

    const info = quickams.getData(fieldContext, "info", label);

    const actualLabel = label.substring(0, label.indexOf("("));
    let resourceField = {
        "label": actualLabel,
        "type": "select",
        "info": info,
        "props": {
            "placeholder": "请选择"+actualLabel,
            "clearable": true,
            "multiple": false,
            "options": options,
        },
        "default": fieldContext["defaultValue"]
    };
    for(let prop in fieldContext["props"]){
        resourceField["props"][prop] = fieldContext["props"][prop];
    }
    context["resourceField"] = resourceField;
}