package cn.schoolwow.ams.domain.block.list.clazz;

import cn.schoolwow.ams.domain.block.list.clazz.crud.ClazzListBlockListener;
import cn.schoolwow.ams.domain.block.list.common.ListBlockOption;

public class ClazzListBlockOption extends ListBlockOption {
    /**请求实体类*/
    public Class requestClass;

    /**响应实体类*/
    public Class responseClass;

    /**名称*/
    public String clazzName;

    /**增删查改接口*/
    public ClazzListBlockListener clazzListBlockAPIListener = new ClazzListBlockListener();

    public ClazzListBlockOption(String projectName, String displayName, Class requestClass, Class responseClass, String clazzName) {
        this.projectName = projectName;
        this.displayName = displayName;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.clazzName = clazzName;
    }

    public ClazzListBlockOption(String projectName, String displayName, Class entityClass) {
        this.projectName = projectName;
        this.displayName = displayName;
        this.requestClass = entityClass;
        this.responseClass = entityClass;
        this.clazzName = entityClass.getSimpleName();
    }
}
