package cn.schoolwow.ams.domain.block.list.common;

import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;

import java.util.List;

public class ListBlockPagingResponse {
    /**列表*/
    public JSONArray list;

    /**总个数*/
    public Integer total;

    public ListBlockPagingResponse(List list){
        String listString = JSON.toJSONString(list);
        JSONArray listArray = JSON.parseArray(listString);
        this.list = listArray;
        this.total = list.size();
    }

    public ListBlockPagingResponse(JSONArray list){
        this.list = list;
        this.total = list.size();
    }

    public ListBlockPagingResponse(PageVo pageVo){
        this.list = pageVo.getArray();
        this.total = Math.toIntExact(pageVo.getTotalSize());
    }

    public ListBlockPagingResponse(JSONArray list, Integer total){
        this.list = list;
        this.total = total;
    }
}
