package cn.schoolwow.ams.domain.block.router;

import cn.schoolwow.ams.domain.block.common.BlockOption;

public abstract class AbstractRouterBlock implements RouterBlock {
    protected BlockOption cacheBlockConfig;

    public BlockOption getAMSCacheBlockConfig(){
        if(null==cacheBlockConfig){
            synchronized (this){
                if(null==cacheBlockConfig){
                    cacheBlockConfig = getAMSBlockConfig();
                }
            }
        }
        return cacheBlockConfig;
    }

    @Override
    public String getMenuName(){
        getAMSCacheBlockConfig();
        return cacheBlockConfig.displayName;
    }

    public abstract BlockOption getAMSBlockConfig();
}
