package cn.schoolwow.ams.domain.block.router;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class RouterBlockBuilder {
    private JSONArray routerBlockArray = new JSONArray();

    private static final JSONObject categoryMeta = new JSONObject();
    {
        categoryMeta.put("icon", "ams-icon-petal");
    }
    private static final JSONObject menuMeta = new JSONObject();
    {
        menuMeta.put("icon", "ams-icon-system-icon");
    }

    public static RouterBlockBuilder newInstance(){
        return new RouterBlockBuilder();
    }

    public RouterBlockBuilder block(RouterBlock amsRouterBlock){
        return block(amsRouterBlock.getMenuName(), amsRouterBlock.getBlockUniqueName());
    }

    public RouterBlockBuilder block(String name, String blockName){
        JSONObject routerBlock = new JSONObject();
        routerBlock.put("path", "/"+blockName);
        routerBlock.put("name", name);
        routerBlock.put("block", blockName);
        routerBlock.put("meta", menuMeta);
        routerBlockArray.add(routerBlock);
        return this;
    }

    public RouterBlockBuilder children(String path, String name){
        JSONObject childRouterBlock = new JSONObject();
        childRouterBlock.put("path", path);
        childRouterBlock.put("name", name);
        childRouterBlock.put("meta", categoryMeta);
        childRouterBlock.put("children", new JSONArray());
        routerBlockArray.add(childRouterBlock);

        RouterBlockBuilder childrenBlockBuilder = new RouterBlockBuilder();
        childrenBlockBuilder.routerBlockArray = childRouterBlock.getJSONArray("children");
        return childrenBlockBuilder;
    }

    public JSONArray build(){
        return routerBlockArray;
    }
}
