package cn.schoolwow.ams.module.block.common.flow;

import cn.schoolwow.ams.domain.block.common.BlockOperation;
import cn.schoolwow.ams.domain.block.common.operation.FormBlockHandlerBlockOperation;
import cn.schoolwow.ams.domain.block.common.operation.ListBlockHandlerBlockOperation;
import cn.schoolwow.ams.domain.block.common.operation.OpenDialogBlockOperation;
import cn.schoolwow.ams.domain.block.common.operation.OpenFieldTabBlockOperation;
import cn.schoolwow.ams.module.block.common.domain.BlockOperationContext;
import cn.schoolwow.ams.module.block.form.domain.FormBlockOperationContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.ListBlockOperationContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.OpenDialogOperationContext;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.OpenFieldTabOperationContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;

import java.util.List;

public class SetBlockOperationCommonFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        List<BlockOperation> blockOperationList = (List<BlockOperation>) flowContext.getData("blockOperationList");
        List<BlockOperationContext> blockOperationContextList = (List<BlockOperationContext>) flowContext.getData("blockOperationContextList");

        for(BlockOperation blockOperation : blockOperationList){
            if(blockOperation instanceof FormBlockHandlerBlockOperation){
                FormBlockHandlerBlockOperation formBlockHandlerBlockOperation = (FormBlockHandlerBlockOperation) blockOperation;
                FormBlockOperationContext formBlockOperationContext = new FormBlockOperationContext();

                formBlockOperationContext.formBlockOperationHandler = formBlockHandlerBlockOperation.formBlockOperationHandler;

                flowContext.putCurrentFlowInstanceData(formBlockHandlerBlockOperation,  BlockOperation.class);
                flowContext.putCurrentFlowInstanceData(formBlockOperationContext,  BlockOperationContext.class);
            }
            if(blockOperation instanceof ListBlockHandlerBlockOperation){
                ListBlockHandlerBlockOperation listBlockHandlerBlockOperation = (ListBlockHandlerBlockOperation) blockOperation;
                ListBlockOperationContext listBlockOperationContext = new ListBlockOperationContext();

                listBlockOperationContext.position = listBlockHandlerBlockOperation.position.name();
                listBlockOperationContext.refreshList = listBlockHandlerBlockOperation.refreshList;
                listBlockOperationContext.showCustomerMessage = listBlockHandlerBlockOperation.showCustomerMessage;
                listBlockOperationContext.listBlockOperationHandler = listBlockHandlerBlockOperation.listBlockOperationHandler;

                flowContext.putCurrentFlowInstanceData(listBlockHandlerBlockOperation,  BlockOperation.class);
                flowContext.putCurrentFlowInstanceData(listBlockOperationContext,  BlockOperationContext.class);
            }
            if(blockOperation instanceof OpenDialogBlockOperation){
                OpenDialogBlockOperation openDialogBlockOperation = (OpenDialogBlockOperation) blockOperation;
                OpenDialogOperationContext openDialogOperationContext = new OpenDialogOperationContext();

                openDialogOperationContext.routerBlockName = openDialogBlockOperation.routerBlock.getBlockUniqueName();
                openDialogOperationContext.routerFieldNameMap = openDialogBlockOperation.routerFieldNameMap;
                if(openDialogOperationContext.routerFieldNameMap.isEmpty()){
                    throw new IllegalArgumentException("跳转字段不能为空!涉及类:"+openDialogBlockOperation.routerBlock.getMenuName());
                }

                flowContext.putCurrentFlowInstanceData(openDialogBlockOperation,  BlockOperation.class);
                flowContext.putCurrentFlowInstanceData(openDialogOperationContext,  BlockOperationContext.class);
            }
            if(blockOperation instanceof OpenFieldTabBlockOperation){
                OpenFieldTabBlockOperation openFieldTabBlockOperation = (OpenFieldTabBlockOperation) blockOperation;
                OpenFieldTabOperationContext openFieldTabOperationContext = new OpenFieldTabOperationContext();

                openFieldTabOperationContext.fieldNames = openFieldTabBlockOperation.fieldNames;

                flowContext.putCurrentFlowInstanceData(openFieldTabBlockOperation,  BlockOperation.class);
                flowContext.putCurrentFlowInstanceData(openFieldTabOperationContext,  BlockOperationContext.class);
            }

            setBlockOperationContext(flowContext);
            BlockOperationContext blockOperationContext = flowContext.checkInstanceData(BlockOperationContext.class);
            blockOperationContextList.add(blockOperationContext);
        }
    }

    @Override
    public String name() {
        return "设置用户操作列表公共流程";
    }

    private void setBlockOperationContext(FlowContext flowContext){
        BlockOperationContext blockOperationContext = flowContext.checkInstanceData(BlockOperationContext.class);
        BlockOperation blockOperation = flowContext.checkInstanceData(BlockOperation.class);

        blockOperationContext.type = blockOperation.blockOperationType.name();
        blockOperationContext.label = blockOperation.label;
        blockOperationContext.icon = blockOperation.icon;
        blockOperationContext.buttonType = blockOperation.blockButtonType.name().toLowerCase();
        blockOperationContext.copyResult = blockOperation.copyResult;
        blockOperationContext.showButtonOptionList.addAll(blockOperation.showButtonOptionList);
    }
}
