package cn.schoolwow.ams.module.block.form.controller;

import cn.schoolwow.ams.domain.block.form.FormBlockRequest;
import cn.schoolwow.ams.module.block.form.service.FormBlockUserOperationServiceFlow;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/ams/api/formBlock")
public class FormBlockController {
    @Autowired
    private QuickFlow amsFlow;

    @RequestMapping("/{projectName}/{simpleName}/userOperation")
    public JSONObject userOperation(
            @PathVariable("projectName") String projectName,
            @PathVariable("simpleName") String simpleName,
            @RequestBody FormBlockRequest formBlockRequest
    ) {
        FlowContext flowContext = amsFlow.startFlow(new FormBlockUserOperationServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("simpleName", simpleName)
                .putTemporaryInstanceData(formBlockRequest)
                .execute();
        JSONObject result = flowContext.getData("result", JSONObject.class);
        return result;
    }
}
