package cn.schoolwow.ams.module.block.form.service;

import cn.schoolwow.ams.domain.block.form.FormBlockRequest;
import cn.schoolwow.ams.module.block.form.domain.FormBlockContext;
import cn.schoolwow.ams.module.block.form.domain.FormBlockOperationContext;
import cn.schoolwow.ams.module.initial.domain.InitialAMSContext;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.util.domain.query.instanceList.QueryInstanceList;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.Validate;

public class FormBlockUserOperationServiceFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setFormBlockContext(flowContext);
        executeFormBlockUserOperation(flowContext);
    }

    @Override
    public String name() {
        return "处理FormBlock的用户操作服务流程";
    }

    private void setFormBlockContext(FlowContext flowContext){
        String projectName = (String) flowContext.checkData("projectName");
        String simpleName = (String) flowContext.checkData("simpleName");
        InitialAMSContext initialAMSContext = flowContext.checkInstanceData(InitialAMSContext.class);

        for(FormBlockContext formBlockContext:initialAMSContext.formBlockContextList){
            if(formBlockContext.projectName.equalsIgnoreCase(projectName)
                    &&formBlockContext.formClass.getSimpleName().equalsIgnoreCase(simpleName)
            ){
                flowContext.putTemporaryInstanceData(formBlockContext);
                break;
            }
        }
        if(!flowContext.containInstanceKey(FormBlockContext.class)){
            throw new IllegalArgumentException("查找FormBlockContext上下文失败!项目名:"+projectName+",实体类名:"+simpleName);
        }
    }

    private void executeFormBlockUserOperation(FlowContext flowContext) throws Exception {
        FormBlockContext formBlockContext = flowContext.checkInstanceData(FormBlockContext.class);
        FormBlockRequest formBlockRequest = flowContext.checkInstanceData(FormBlockRequest.class);

        FormBlockOperationContext formBlockOperationContext = QueryInstanceList.newQuery(formBlockContext.blockOperationContextList)
                .addQuery("label", formBlockRequest.label)
                .execute()
                .getOne();
        Validate.notNull(formBlockOperationContext, "当前表单未配置操作按钮执行逻辑!按钮名称:"+formBlockRequest.label);

        JSONObject result = formBlockOperationContext.formBlockOperationHandler.handle(formBlockRequest);
        flowContext.putReturnData("result", result);
    }
}
