package cn.schoolwow.ams.module.block.listBlock.clazzBlock.controller;

import cn.schoolwow.ams.domain.block.list.common.ListBlockPagingResponse;
import cn.schoolwow.ams.module.block.listBlock.clazzBlock.service.ClazzListBlockListServiceFlow;
import cn.schoolwow.ams.module.block.listBlock.clazzBlock.service.ClazzListBlockUpdateServiceFlow;
import cn.schoolwow.ams.module.block.listBlock.clazzBlock.service.ClazzListBlockUserOperationServiceFlow;
import cn.schoolwow.ams.module.block.listBlock.common.domain.operation.ListBlockRequest;
import cn.schoolwow.quickflow.QuickFlow;
import cn.schoolwow.quickflow.domain.FlowContext;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("/ams/api/clazzListBlock")
public class ClazzListBlockController {
    @Autowired
    private QuickFlow amsFlow;

    @RequestMapping("/{projectName}/{clazzName}/list")
    public ListBlockPagingResponse list(
            @PathVariable("projectName") String projectName,
            @PathVariable("clazzName") String clazzName,
            @RequestParam Map<String,Object> amsListConditionMap
    ) {
        JSONObject conditionMap = new JSONObject(amsListConditionMap);
        FlowContext flowContext = amsFlow.startFlow(new ClazzListBlockListServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("clazzName", clazzName)
                .putCurrentCompositeFlowData("conditionMap", conditionMap)
                .execute();
        ListBlockPagingResponse amsListBlockPagingResponse = flowContext.checkInstanceData(ListBlockPagingResponse.class);
        return amsListBlockPagingResponse;
    }

    @RequestMapping("/{projectName}/{clazzName}/update")
    public void update(
            @PathVariable("projectName") String projectName,
            @PathVariable("clazzName") String clazzName,
            @RequestBody JSONObject requestBody
    ) {
        amsFlow.startFlow(new ClazzListBlockUpdateServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("clazzName", clazzName)
                .putCurrentCompositeFlowData("requestBody", requestBody)
                .execute();
    }

    @RequestMapping("/{projectName}/{clazzName}/userOperation")
    public JSONObject userOperation(
            @PathVariable("projectName") String projectName,
            @PathVariable("clazzName") String clazzName,
            @RequestBody ListBlockRequest listBlockRequest
    ) {
        FlowContext flowContext = amsFlow.startFlow(new ClazzListBlockUserOperationServiceFlow())
                .putCurrentCompositeFlowData("projectName", projectName)
                .putCurrentCompositeFlowData("clazzName", clazzName)
                .putCurrentCompositeFlowInstanceData(listBlockRequest)
                .execute();
        JSONObject handleResult = flowContext.getData("handleResult", JSONObject.class);
        return handleResult;
    }
}
